# Configuração de Notificações WhatsApp

## Visão Geral
Este sistema permite enviar notificações automáticas por WhatsApp para compromissos agendados. As notificações são enviadas com antecedência configurável (padrão: 2 horas antes do compromisso).

## Pré-requisitos

### 1. Conta Twilio
- Crie uma conta em [https://www.twilio.com](https://www.twilio.com)
- Obtenha suas credenciais:
  - Account SID
  - Auth Token
  - Número de telefone WhatsApp Business

### 2. Configuração do Banco de Dados
Execute o script SQL para criar as tabelas necessárias:
```bash
mysql -u [usuario] -p [nome_do_banco] < sql/whatsapp_notifications.sql
```

## Configuração Inicial

### 1. Acesse as Configurações
1. Faça login como administrador
2. Vá para **Configurações** → **Configurar WhatsApp**
3. Configure as abas conforme descrito abaixo

### 2. Aba "Configurações Gerais"
- **Ativar Notificações**: Marque para habilitar o sistema
- **Antecedência**: Defina quantas horas antes enviar (padrão: 2 horas)
- **Horário de Funcionamento**: Configure o período para envio (08:00 às 20:00)
- **Template da Mensagem**: Personalize a mensagem usando variáveis:
  - `{titulo}` - Título do compromisso
  - `{data}` - Data do compromisso
  - `{hora}` - Horário do compromisso
  - `{responsavel}` - Nome do responsável

### 3. Aba "Credenciais Twilio"
- **Account SID**: Cole o SID da sua conta Twilio
- **Auth Token**: Cole o token de autenticação
- **Número WhatsApp**: Número do WhatsApp Business (formato: +5511999999999)

### 4. Aba "Teste de Envio"
- Use esta aba para testar se as configurações estão corretas
- Digite um número de telefone e uma mensagem de teste
- Clique em "Enviar Teste" para verificar o funcionamento

## Configuração do Cron Job

Para que as notificações sejam enviadas automaticamente, configure um cron job:

```bash
# Edite o crontab
crontab -e

# Adicione esta linha para verificar a cada 30 minutos
0,30 * * * * /usr/bin/php /caminho/para/seu/projeto/src/cron/whatsapp_scheduler.php
```

### Opções do Scheduler
```bash
# Modo normal (produção)
php src/cron/whatsapp_scheduler.php

# Modo teste (não envia mensagens reais)
php src/cron/whatsapp_scheduler.php --test

# Limpeza de logs antigos (remove logs com mais de 30 dias)
php src/cron/whatsapp_scheduler.php --cleanup
```

## Como Usar

### 1. Ao Criar um Compromisso
1. Preencha os dados do compromisso normalmente
2. Marque a opção "Enviar lembrete por WhatsApp"
3. Salve o compromisso

### 2. Monitoramento
- Acesse **Configurações** → **Configurar WhatsApp** → **Histórico**
- Visualize todas as notificações enviadas, com status e detalhes
- Monitore estatísticas de envio e taxa de sucesso

## Solução de Problemas

### Mensagens não estão sendo enviadas
1. Verifique se o cron job está configurado e rodando
2. Confirme as credenciais do Twilio na aba "Credenciais"
3. Verifique se o sistema está ativo nas "Configurações Gerais"
4. Consulte os logs no "Histórico" para identificar erros

### Erro de autenticação Twilio
- Verifique se o Account SID e Auth Token estão corretos
- Confirme se o número WhatsApp está verificado no Twilio
- Teste o envio na aba "Teste de Envio"

### Compromissos não aparecem para notificação
- Verifique se o checkbox "Enviar lembrete por WhatsApp" foi marcado
- Confirme se o compromisso está dentro do horário de funcionamento
- Verifique se a antecedência está configurada corretamente

## Logs e Auditoria

Todos os envios são registrados na tabela `notificacoes_whatsapp` com:
- Data e hora do envio
- Status (Enviada, Erro, Falhou)
- Detalhes do erro (se houver)
- Informações do compromisso

## Segurança

- As credenciais são armazenadas criptografadas no banco
- Apenas administradores podem configurar o sistema
- Logs são mantidos para auditoria
- Limpeza automática de logs antigos disponível

## Suporte

Para suporte técnico:
1. Verifique os logs no "Histórico"
2. Execute o teste de envio
3. Consulte a documentação do Twilio para códigos de erro específicos