<?php
// /gabinete/login.php — Autônomo (sem includes). UTF-8 sem BOM, nada antes deste <?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

/** URL base da sua app:
 *  - http://localhost:8888/gabinete → '/gabinete'
 *  - http://localhost:8888/         → ''
 */
$BASE_PATH = '/gabinete'; // <<< ajuste se necessário

// ===== CONFIG BANCO (MAMP) =====
$DB_HOST   = '127.0.0.1';                 // 127.0.0.1 para forçar TCP
$DB_PORT   = 8889;                        // porta MySQL do MAMP
$DB_NAME   = 'gabinete_bd';               // <<< NOME DO SEU BANCO
$DB_USER   = 'root';
$DB_PASS   = 'root';                      // padrão MAMP
$DB_SOCKET = '/Applications/MAMP/tmp/mysql/mysql.sock'; // fallback opcional

// Redirecionamento simples
function _redir($base, $path) {
  if ($path === '' || $path[0] !== '/') $path = '/' . $path;
  header('Location: ' . $base . $path, true, 302);
  exit;
}

// Tenta conectar via TCP (porta) e, se falhar, por socket do MAMP
function pdo_connect_mamp_db($host, $port, $db, $user, $pass, $socket) {
  // 1) TCP com dbname
  $dsn1 = "mysql:host={$host};port={$port};dbname={$db};charset=utf8mb4";
  try {
    return new PDO($dsn1, $user, $pass, [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES => false
    ]);
  } catch (Throwable $e) {
    // tenta socket
  }
  // 2) Socket (se existir)
  if (is_string($socket) && file_exists($socket)) {
    $dsn2 = "mysql:unix_socket={$socket};dbname={$db};charset=utf8mb4";
    return new PDO($dsn2, $user, $pass, [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES => false
    ]);
  }
  // 3) Rejoga erro original da tentativa TCP
  return new PDO($dsn1, $user, $pass);
}

$erro = '';
$email_post = '';
$ja_logado = !empty($_SESSION['user_id']);

// Apenas POST autentica (evita loops)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email_post = isset($_POST['email']) ? trim($_POST['email']) : '';
  $senha_post = isset($_POST['senha']) ? (string)$_POST['senha'] : '';

  if ($email_post === '' || $senha_post === '') {
    $erro = 'Informe e-mail e senha.';
  } else {
    try {
      $pdo = pdo_connect_mamp_db($DB_HOST, $DB_PORT, $DB_NAME, $DB_USER, $DB_PASS, $DB_SOCKET);

      // Consulta usuário ativo
      $st = $pdo->prepare("SELECT id,nome,email,senha,nivel_acesso,ativo
                           FROM usuarios
                           WHERE email=? AND ativo=1
                           LIMIT 1");
      $st->execute([$email_post]);
      $user = $st->fetch();

      if (!$user) {
        $erro = 'Usuário não encontrado ou inativo.';
      } else {
        if (!empty($user['senha']) && password_verify($senha_post, $user['senha'])) {
          $_SESSION['user_id'] = (int)$user['id'];
          $_SESSION['email']   = $user['email'];
          $_SESSION['nome']    = $user['nome'];
          $_SESSION['nivel']   = $user['nivel_acesso'];
          _redir($BASE_PATH, '/src/views/dashboard/index.php');
        } else {
          $erro = 'Senha inválida.';
        }
      }
    } catch (Throwable $e) {
      $erro = 'Erro de conexão/autenticação no banco: ' . $e->getMessage();
    }
  }
}
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <title>Login</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <style>
    :root { --brand-blue:#0E5FD8; }
    *{box-sizing:border-box} body{margin:0;background:#f7f8fa;font-family:system-ui,-apple-system,Segoe UI,Roboto,Arial}
    .wrap{display:flex;min-height:100vh;align-items:center;justify-content:center;padding:24px}
    .card{width:100%;max-width:380px;background:#fff;border:1px solid #e8e8e8;border-radius:14px;box-shadow:0 2px 10px rgba(0,0,0,.06);padding:22px}
    h1{margin:0 0 14px 0;font-size:20px;color:#0f172a;text-align:center}
    .form-row{margin-bottom:12px}
    label{display:block;font-size:13px;color:#334155;margin-bottom:6px}
    input[type="email"],input[type="password"]{width:100%;padding:10px 12px;border:1px solid #dfe3e8;border-radius:10px}
    .btn{display:inline-block;width:100%;padding:10px 12px;border-radius:10px;background:var(--brand-blue);color:#fff;border:0;font-weight:600;cursor:pointer}
    .erro{margin:-4px 0 10px 0;color:#b91c1c;font-size:13px}
    .ok{padding:10px;border:1px solid #c7f2c8;background:#effef0;color:#065f46;border-radius:10px;margin-bottom:12px;text-align:center}
    .actions{display:flex;gap:8px;margin-bottom:12px}
    .btn-sec{display:inline-block;width:100%;padding:10px 12px;border-radius:10px;background:#e8eefc;color:#0E5FD8;border:0;font-weight:600;text-align:center;text-decoration:none}
  </style>
</head>
<body>
  <div class="wrap">
    <form class="card" method="post" action="">
      <h1>Acessar</h1>

      <?php if ($ja_logado): ?>
        <div class="ok">Você já está logado.</div>
        <div class="actions">
          <a class="btn-sec" href="<?php echo htmlspecialchars($BASE_PATH.'/src/views/dashboard/index.php'); ?>">Ir para o painel</a>
          <a class="btn-sec" href="<?php echo htmlspecialchars($BASE_PATH.'/logout.php'); ?>">Sair</a>
        </div>
      <?php endif; ?>

      <?php if ($erro !== ''): ?>
        <div class="erro"><?php echo htmlspecialchars($erro); ?></div>
      <?php endif; ?>

      <div class="form-row">
        <label for="email">E-mail</label>
        <input id="email" type="email" name="email" value="<?php echo htmlspecialchars($email_post); ?>" required>
      </div>

      <div class="form-row">
        <label for="senha">Senha</label>
        <input id="senha" type="password" name="senha" required>
      </div>

      <div class="form-row">
        <button class="btn" type="submit">Entrar</button>
      </div>
    </form>
  </div>
</body>
</html>
