-- Script SQL para atualizar tabela documentos existente
-- Execute este script para adicionar colunas necessárias

USE gabinete;

-- Adicionar colunas faltantes na tabela documentos (sintaxe compatível)
ALTER TABLE documentos 
ADD COLUMN tipo_midia ENUM('imagem', 'video', 'audio', 'documento') DEFAULT 'documento' AFTER tipo_arquivo;

ALTER TABLE documentos 
ADD COLUMN descricao TEXT AFTER titulo;

ALTER TABLE documentos 
ADD COLUMN largura INT NULL COMMENT 'Largura em pixels' AFTER tamanho_arquivo;

ALTER TABLE documentos 
ADD COLUMN altura INT NULL COMMENT 'Altura em pixels' AFTER largura;

ALTER TABLE documentos 
ADD COLUMN duracao INT NULL COMMENT 'Duração em segundos' AFTER altura;

ALTER TABLE documentos 
ADD COLUMN thumbnail VARCHAR(255) NULL COMMENT 'Caminho do thumbnail' AFTER duracao;

ALTER TABLE documentos 
ADD COLUMN tags TEXT NULL COMMENT 'Tags separadas por vírgula' AFTER thumbnail;

ALTER TABLE documentos 
ADD COLUMN evento_campanha VARCHAR(255) NULL COMMENT 'Evento ou campanha' AFTER tags;

-- Atualizar registros existentes baseado no tipo de arquivo
UPDATE documentos SET tipo_midia = 'imagem' 
WHERE tipo_arquivo IN ('image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'image/webp', 'image/bmp');

UPDATE documentos SET tipo_midia = 'video' 
WHERE tipo_arquivo IN ('video/mp4', 'video/avi', 'video/mov', 'video/wmv', 'video/flv', 'video/webm');

UPDATE documentos SET tipo_midia = 'audio' 
WHERE tipo_arquivo IN ('audio/mp3', 'audio/wav', 'audio/ogg', 'audio/m4a', 'audio/flac');

UPDATE documentos SET tipo_midia = 'documento' 
WHERE tipo_midia IS NULL OR tipo_midia = 'documento';

-- Criar índices para melhor performance
CREATE INDEX idx_documentos_tipo_midia ON documentos(tipo_midia);
CREATE INDEX idx_documentos_tags ON documentos(tags(100));
CREATE INDEX idx_documentos_evento_campanha ON documentos(evento_campanha);

-- Verificar estrutura atualizada
SELECT 'Colunas adicionadas com sucesso!' as status;
SHOW COLUMNS FROM documentos;

-- Mostrar estatísticas por tipo de mídia
SELECT 
    tipo_midia,
    COUNT(*) as total_arquivos,
    ROUND(SUM(tamanho_arquivo)/1024/1024, 2) as tamanho_total_mb
FROM documentos 
GROUP BY tipo_midia;