-- Script SQL para inserir demandas na coluna demanda da tabela eleitores
-- Execute este script APÓS adicionar a coluna demanda na tabela

USE gabinete_bd;

-- Atualizar coluna demanda para os eleitores específicos cadastrados
-- Baseado nos registros criados anteriormente

UPDATE eleitores 
SET demanda = 'Saúde' 
WHERE nome_completo = 'Maria Silva Santos';

UPDATE eleitores 
SET demanda = 'Assistência Social' 
WHERE nome_completo = 'João Carlos Oliveira';

UPDATE eleitores 
SET demanda = 'Jurídico' 
WHERE nome_completo = 'Ana Paula Costa';

UPDATE eleitores 
SET demanda = 'Moradia' 
WHERE nome_completo = 'Carlos Eduardo Lima';

UPDATE eleitores 
SET demanda = 'Ação Social' 
WHERE nome_completo = 'Fernanda Rodrigues';

UPDATE eleitores 
SET demanda = 'Saúde' 
WHERE nome_completo = 'Roberto Almeida';

UPDATE eleitores 
SET demanda = 'Ação Saúde' 
WHERE nome_completo = 'Juliana Pereira';

UPDATE eleitores 
SET demanda = 'Fiscalização' 
WHERE nome_completo = 'Antonio José Silva';

UPDATE eleitores 
SET demanda = 'Jurídico' 
WHERE nome_completo = 'Patrícia Mendes';

UPDATE eleitores 
SET demanda = 'Reunião' 
WHERE nome_completo = 'Marcos Vinícius Santos';

-- Verificar quantos registros foram atualizados
SELECT 
    COUNT(*) as 'Total de Eleitores com Demanda Inserida'
FROM eleitores 
WHERE demanda IS NOT NULL;

-- Mostrar todos os eleitores com suas demandas
SELECT 
    id,
    nome_completo,
    telefone,
    bairro,
    tipo,
    demanda as categoria_demanda
FROM eleitores 
WHERE demanda IS NOT NULL
ORDER BY nome_completo;

-- Estatísticas por categoria de demanda
SELECT 
    demanda as categoria,
    COUNT(*) as quantidade_eleitores
FROM eleitores 
WHERE demanda IS NOT NULL
GROUP BY demanda
ORDER BY quantidade_eleitores DESC;

-- Verificar se todos os 10 eleitores foram atualizados
SELECT 
    'Eleitores com demanda inserida:' as status,
    COUNT(*) as quantidade
FROM eleitores 
WHERE nome_completo IN (
    'Maria Silva Santos',
    'João Carlos Oliveira', 
    'Ana Paula Costa',
    'Carlos Eduardo Lima',
    'Fernanda Rodrigues',
    'Roberto Almeida',
    'Juliana Pereira',
    'Antonio José Silva',
    'Patrícia Mendes',
    'Marcos Vinícius Santos'
) AND demanda IS NOT NULL;