-- Script SQL para inserir dados de teste na tabela employees
-- Execute este script após criar as tabelas de RH

-- Inserir colaboradores de teste
INSERT INTO employees (
    full_name, 
    cpf, 
    rg, 
    birth_date, 
    address, 
    phone_number, 
    job_title, 
    salary, 
    hire_date, 
    contract_type, 
    cost_center, 
    bank_name, 
    agency_number, 
    account_number, 
    status
) VALUES 
-- Colaborador 1 - Gerente
(
    'Maria Silva Santos',
    '123.456.789-01',
    '12.345.678-9',
    '1985-03-15',
    'Rua das Flores, 123, Centro, São Paulo - SP, CEP: 01234-567',
    '(11) 98765-4321',
    'Gerente Administrativo',
    8500.00,
    '2020-01-15',
    'CLT',
    'Administração',
    'Banco do Brasil',
    '1234-5',
    '12345-6',
    'ativo'
),

-- Colaborador 2 - Assistente
(
    'João Carlos Oliveira',
    '987.654.321-02',
    '98.765.432-1',
    '1990-07-22',
    'Av. Paulista, 456, Bela Vista, São Paulo - SP, CEP: 01310-100',
    '(11) 91234-5678',
    'Assistente Administrativo',
    3500.00,
    '2021-03-10',
    'CLT',
    'Administração',
    'Caixa Econômica Federal',
    '0987-6',
    '98765-4',
    'ativo'
),

-- Colaborador 3 - Analista
(
    'Ana Paula Costa',
    '456.789.123-03',
    '45.678.912-3',
    '1988-11-08',
    'Rua Augusta, 789, Consolação, São Paulo - SP, CEP: 01305-000',
    '(11) 95555-1234',
    'Analista de Recursos Humanos',
    5200.00,
    '2019-08-20',
    'CLT',
    'Recursos Humanos',
    'Itaú Unibanco',
    '5678-9',
    '56789-0',
    'ativo'
),

-- Colaborador 4 - Estagiário
(
    'Pedro Henrique Lima',
    '789.123.456-04',
    '78.912.345-6',
    '2000-05-12',
    'Rua da Consolação, 321, República, São Paulo - SP, CEP: 01302-907',
    '(11) 94444-5678',
    'Estagiário de TI',
    1800.00,
    '2023-02-01',
    'Estagiário',
    'Tecnologia',
    'Santander',
    '3456-7',
    '34567-8',
    'ativo'
),

-- Colaborador 5 - Coordenador
(
    'Carla Fernanda Souza',
    '321.654.987-05',
    '32.165.498-7',
    '1982-09-30',
    'Rua Oscar Freire, 654, Jardins, São Paulo - SP, CEP: 01426-001',
    '(11) 97777-8888',
    'Coordenadora de Projetos',
    7200.00,
    '2018-05-15',
    'CLT',
    'Projetos',
    'Bradesco',
    '7890-1',
    '78901-2',
    'ativo'
),

-- Colaborador 6 - Terceirizado
(
    'Roberto Silva Pereira',
    '654.987.321-06',
    '65.498.732-1',
    '1975-12-03',
    'Rua Haddock Lobo, 987, Cerqueira César, São Paulo - SP, CEP: 01414-001',
    '(11) 96666-7777',
    'Técnico de Manutenção',
    4200.00,
    '2022-01-10',
    'Terceirizado',
    'Manutenção',
    'Banco do Brasil',
    '2468-1',
    '24681-3',
    'ativo'
),

-- Colaborador 7 - PJ
(
    'Luciana Martins Alves',
    '147.258.369-07',
    '14.725.836-9',
    '1987-04-18',
    'Av. Faria Lima, 1234, Itaim Bibi, São Paulo - SP, CEP: 04538-132',
    '(11) 93333-4444',
    'Consultora Jurídica',
    12000.00,
    '2021-09-01',
    'PJ',
    'Jurídico',
    'Itaú Unibanco',
    '1357-9',
    '13579-2',
    'ativo'
),

-- Colaborador 8 - Assistente (Inativo para teste)
(
    'Carlos Eduardo Santos',
    '258.369.147-08',
    '25.836.914-7',
    '1992-01-25',
    'Rua Bela Cintra, 555, Consolação, São Paulo - SP, CEP: 01415-000',
    '(11) 92222-3333',
    'Assistente Financeiro',
    3800.00,
    '2020-06-15',
    'CLT',
    'Financeiro',
    'Caixa Econômica Federal',
    '9876-5',
    '98765-4',
    'inativo'
),

-- Colaborador 9 - Analista
(
    'Fernanda Oliveira Cruz',
    '369.147.258-09',
    '36.914.725-8',
    '1989-08-14',
    'Rua Estados Unidos, 777, Jardins, São Paulo - SP, CEP: 01427-001',
    '(11) 91111-2222',
    'Analista Contábil',
    4800.00,
    '2019-11-20',
    'CLT',
    'Contabilidade',
    'Santander',
    '4567-8',
    '45678-9',
    'ativo'
),

-- Colaborador 10 - Supervisor
(
    'Ricardo Almeida Nunes',
    '741.852.963-10',
    '74.185.296-3',
    '1983-06-07',
    'Av. Rebouças, 888, Pinheiros, São Paulo - SP, CEP: 05402-000',
    '(11) 98888-9999',
    'Supervisor de Vendas',
    6500.00,
    '2017-12-01',
    'CLT',
    'Comercial',
    'Bradesco',
    '8520-7',
    '85207-4',
    'ativo'
);

-- Verificar os dados inseridos
SELECT 
    id,
    full_name,
    cpf,
    job_title,
    salary,
    contract_type,
    status,
    hire_date
FROM employees 
ORDER BY hire_date DESC;