-- Banco de dados completo com todas as tabelas necessárias
-- Execute este script no phpMyAdmin para criar/atualizar o banco

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";

-- Cria o banco se não existir
CREATE DATABASE IF NOT EXISTS `gabinete_bd` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
USE `gabinete_bd`;

-- Tabela de usuários
CREATE TABLE IF NOT EXISTS `usuarios` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nome` varchar(150) NOT NULL,
  `email` varchar(150) NOT NULL,
  `senha` varchar(255) NOT NULL,
  `nivel_acesso` enum('Admin','Assessor','Estagiario') NOT NULL,
  `ativo` tinyint(1) NOT NULL DEFAULT '1',
  `data_criacao` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `google_auth_token` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabela de eleitores
CREATE TABLE IF NOT EXISTS `eleitores` (
  `id` int NOT NULL AUTO_INCREMENT,
  `nome_completo` varchar(255) NOT NULL,
  `data_nascimento` date DEFAULT NULL,
  `telefone` varchar(20) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `endereco` varchar(255) DEFAULT NULL,
  `bairro` varchar(100) DEFAULT NULL,
  `cidade` varchar(100) DEFAULT 'Belém',
  `cep` varchar(9) DEFAULT NULL,
  `sexo` enum('Masculino','Feminino','Outro') DEFAULT NULL,
  `tipo` enum('Apoiador','Liderança') NOT NULL,
  `observacao` text,
  `data_cadastro` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabela de agendas (que estava faltando)
CREATE TABLE IF NOT EXISTS `agendas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_eleitor` int DEFAULT NULL,
  `titulo` varchar(255) NOT NULL,
  `descricao` text,
  `categoria` enum('Saúde','Jurídico','Assistência Social','Moradia','Visita','Ação Social','Ação Saúde','Fiscalização','Reunião') NOT NULL,
  `data_inicio` datetime NOT NULL,
  `data_fim` datetime DEFAULT NULL,
  `id_responsavel` int DEFAULT NULL,
  `google_calendar_event_id` varchar(255) DEFAULT NULL,
  `data_criacao` timestamp DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_eleitor` (`id_eleitor`),
  KEY `id_responsavel` (`id_responsavel`),
  CONSTRAINT `agendas_ibfk_1` FOREIGN KEY (`id_eleitor`) REFERENCES `eleitores` (`id`) ON DELETE SET NULL,
  CONSTRAINT `agendas_ibfk_2` FOREIGN KEY (`id_responsavel`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabela de demandas
CREATE TABLE IF NOT EXISTS `demandas` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_eleitor` int NOT NULL,
  `titulo` varchar(255) NOT NULL,
  `descricao` text,
  `categoria` enum('Saúde','Jurídico','Assistência Social','Moradia','Visita','Ação Social','Ação Saúde','Fiscalização','Reunião') NOT NULL,
  `status` enum('Aberta','Em Andamento','Concluída','Cancelada') NOT NULL DEFAULT 'Aberta',
  `data_abertura` date NOT NULL,
  `data_conclusao` date DEFAULT NULL,
  `id_responsavel` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_eleitor` (`id_eleitor`),
  KEY `id_responsavel` (`id_responsavel`),
  CONSTRAINT `demandas_ibfk_1` FOREIGN KEY (`id_eleitor`) REFERENCES `eleitores` (`id`) ON DELETE CASCADE,
  CONSTRAINT `demandas_ibfk_2` FOREIGN KEY (`id_responsavel`) REFERENCES `usuarios` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Tabela de documentos
CREATE TABLE IF NOT EXISTS `documentos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `id_usuario` int NOT NULL,
  `titulo` varchar(255) NOT NULL,
  `descricao` text,
  `nome_arquivo` varchar(255) NOT NULL,
  `caminho_arquivo` varchar(255) NOT NULL,
  `tipo_arquivo` varchar(100) NOT NULL,
  `tamanho_arquivo` int NOT NULL,
  `categoria` enum('Ofício','Requerimento','Projetos','Prestação de Contas','Diversos') NOT NULL,
  `data_upload` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `id_usuario` (`id_usuario`),
  CONSTRAINT `documentos_ibfk_1` FOREIGN KEY (`id_usuario`) REFERENCES `usuarios` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Insere usuário administrador padrão
-- Senha: admin123
INSERT INTO `usuarios` (`nome`, `email`, `senha`, `nivel_acesso`, `ativo`) VALUES
('Administrador', 'admin@gabinete.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Admin', 1)
ON DUPLICATE KEY UPDATE `senha` = '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi';

COMMIT;
