-- Cria o banco de dados se ele não existir
CREATE DATABASE IF NOT EXISTS `gabinete_db` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

-- Usa o banco de dados
USE `gabinete_db`;

-- Tabela de Usuários do Sistema
CREATE TABLE `usuarios` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `nome` VARCHAR(150) NOT NULL,
  `email` VARCHAR(150) NOT NULL UNIQUE,
  `senha` VARCHAR(255) NOT NULL COMMENT 'Armazenar senhas com hash!',
  `nivel_acesso` ENUM('Admin', 'Assessor', 'Estagiario') NOT NULL,
  `ativo` BOOLEAN NOT NULL DEFAULT TRUE,
  `data_criacao` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

-- Tabela de Eleitores
CREATE TABLE `eleitores` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `nome_completo` VARCHAR(255) NOT NULL,
  `cpf` VARCHAR(14) UNIQUE,
  `data_nascimento` DATE,
  `telefone` VARCHAR(20),
  `email` VARCHAR(255),
  `endereco` VARCHAR(255),
  `bairro` VARCHAR(100),
  `cidade` VARCHAR(100) DEFAULT 'Belém',
  `cep` VARCHAR(9),
  `data_cadastro` TIMESTAMP DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB;

-- Tabela de Demandas (vinculada a um eleitor)
CREATE TABLE `demandas` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `id_eleitor` INT NOT NULL,
  `titulo` VARCHAR(255) NOT NULL,
  `descricao` TEXT NOT NULL,
  `categoria` VARCHAR(100) COMMENT 'Ex: Saúde, Educação, Infraestrutura',
  `status` ENUM('Aberta', 'Em Andamento', 'Concluída', 'Cancelada') NOT NULL DEFAULT 'Aberta',
  `data_abertura` DATE NOT NULL,
  `data_conclusao` DATE,
  `id_responsavel` INT COMMENT 'ID do usuário do sistema responsável',
  FOREIGN KEY (`id_eleitor`) REFERENCES `eleitores`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`id_responsavel`) REFERENCES `usuarios`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB;

-- Estrutura da tabela para `documentos`
CREATE TABLE `documentos` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `id_usuario` INT NOT NULL COMMENT 'Quem fez o upload',
  `titulo` VARCHAR(255) NOT NULL,
  `descricao` TEXT,
  `nome_arquivo` VARCHAR(255) NOT NULL COMMENT 'Nome seguro gerado pelo sistema',
  `caminho_arquivo` VARCHAR(255) NOT NULL,
  `tipo_arquivo` VARCHAR(100) NOT NULL COMMENT 'MIME Type (ex: application/pdf)',
  `tamanho_arquivo` INT NOT NULL COMMENT 'Tamanho em bytes',
  `categoria` ENUM('Ofício', 'Requerimento', 'Projetos', 'Prestação de Contas', 'Diversos') NOT NULL,
  `data_upload` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (`id_usuario`) REFERENCES `usuarios`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB;

-- Adicionando um usuário de exemplo para testes (senha: 'admin123')
INSERT INTO `usuarios` (`nome`, `email`, `senha`, `nivel_acesso`, `ativo`) VALUES
('Administrador', 'admin@gabinete.com', '$2y$10$3PzQE2gJ.D5kR2l.L8l/3u6z.sXfP1JzF0bX.aB.iW.eN/qG.zG2G', 'Admin', 1);