<?php include __DIR__ . 
'/../partials/header.php
'; ?>

<body class="bg-gray-100 font-sans antialiased">
    <div class="min-h-screen">
        <!-- Header Principal Aprimorado -->
        <div class="bg-gradient-to-br from-blue-700 to-indigo-800 text-white shadow-lg">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
                <div class="flex flex-col md:flex-row justify-between items-start md:items-center">
                    <div class="mb-6 md:mb-0">
                        <h1 class="text-4xl font-extrabold mb-2 tracking-tight">Gestão de Colaboradores</h1>
                        <p class="text-blue-200 text-lg">Gerencie sua equipe e acesse módulos de RH com eficiência</p>
                    </div>
                    <div class="flex flex-col sm:flex-row space-y-3 sm:space-y-0 sm:space-x-4">
                        <a href="<?= BASE_URL ?>/employees/create" class="bg-white text-blue-700 px-7 py-3 rounded-full font-bold shadow-md hover:bg-blue-100 hover:text-blue-800 transition-all duration-300 flex items-center justify-center text-lg">
                            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                            Novo Colaborador
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
            <!-- Módulos de RH Aprimorados -->
            <div class="mb-12">
                <h2 class="text-3xl font-bold text-gray-900 mb-8 border-b-2 border-blue-500 pb-2">Módulos de Recursos Humanos</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <!-- Folha de Pagamento -->
                    <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 border border-gray-200">
                        <div class="p-8 flex flex-col items-center">
                            <div class="flex items-center justify-center w-16 h-16 bg-green-50 rounded-full mb-6 shadow-inner">
                                <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                                </svg>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 text-center mb-3">Folha de Pagamento</h3>
                            <p class="text-gray-600 text-center text-base mb-6">Gerencie salários, descontos e benefícios de forma eficiente</p>
                            <a href="<?= BASE_URL ?>/payrolls" class="block w-full bg-green-600 text-white text-center py-3 rounded-xl font-semibold hover:bg-green-700 transition-colors text-lg">
                                Acessar
                            </a>
                        </div>
                    </div>

                    <!-- Relatórios -->
                    <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 border border-gray-200">
                        <div class="p-8 flex flex-col items-center">
                            <div class="flex items-center justify-center w-16 h-16 bg-purple-50 rounded-full mb-6 shadow-inner">
                                <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                                </svg>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 text-center mb-3">Relatórios</h3>
                            <p class="text-gray-600 text-center text-base mb-6">Análises e estatísticas detalhadas de RH</p>
                            <a href="<?= BASE_URL ?>/relatorios" class="block w-full bg-purple-600 text-white text-center py-3 rounded-xl font-semibold hover:bg-purple-700 transition-colors text-lg">
                                Acessar
                            </a>
                        </div>
                    </div>

                    <!-- Controle de Ponto -->
                    <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 border border-gray-200">
                        <div class="p-8 flex flex-col items-center">
                            <div class="flex items-center justify-center w-16 h-16 bg-blue-50 rounded-full mb-6 shadow-inner">
                                <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 text-center mb-3">Controle de Ponto</h3>
                            <p class="text-gray-600 text-center text-base mb-6">Registros de horários e frequência da equipe</p>
                            <a href="<?= BASE_URL ?>/time-records" class="block w-full bg-blue-600 text-white text-center py-3 rounded-xl font-semibold hover:bg-blue-700 transition-colors text-lg">
                                Acessar
                            </a>
                        </div>
                    </div>

                    <!-- Usuários -->
                    <div class="bg-white rounded-2xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 border border-gray-200">
                        <div class="p-8 flex flex-col items-center">
                            <div class="flex items-center justify-center w-16 h-16 bg-orange-50 rounded-full mb-6 shadow-inner">
                                <svg class="w-8 h-8 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                                </svg>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 text-center mb-3">Usuários</h3>
                            <p class="text-gray-600 text-center text-base mb-6">Gerencie o acesso e as permissões dos usuários do sistema</p>
                            <a href="<?= BASE_URL ?>/paineladmin/usuarios" class="block w-full bg-orange-600 text-white text-center py-3 rounded-xl font-semibold hover:bg-orange-700 transition-colors text-lg">
                                Acessar
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filtros Aprimorados -->
            <div class="bg-white rounded-2xl shadow-xl p-8 mb-12 border border-gray-200">
                <h2 class="text-2xl font-bold text-gray-900 mb-6 border-b-2 border-gray-200 pb-3">Filtros de Busca</h2>
                <form method="GET" class="grid grid-cols-1 md:grid-cols-4 gap-6 items-end">
                    <div>
                        <label for="status-filter" class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                        <select id="status-filter" name="status" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200">
                            <option value="">Todos</option>
                            <option value="ativo" <?= ($_GET[
'status
'] ?? 
''
) === 
'ativo'
 ? 
'selected'
 : 
''
 ?>>Ativo</option>
                            <option value="inativo" <?= ($_GET[
'status
'] ?? 
''
) === 
'inativo'
 ? 
'selected'
 : 
''
 ?>>Inativo</option>
                            <option value="demitido" <?= ($_GET[
'status
'] ?? 
''
) === 
'demitido'
 ? 
'selected'
 : 
''
 ?>>Demitido</option>
                        </select>
                    </div>
                    
                    <div>
                        <label for="search-input" class="block text-sm font-medium text-gray-700 mb-2">Buscar</label>
                        <input type="text" id="search-input" name="search" value="<?= htmlspecialchars($_GET[
'search'
] ?? 
''
) ?>" placeholder="Nome, CPF ou cargo..." class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 transition-all duration-200">
                    </div>
                    
                    <div class="col-span-1 md:col-span-2 flex space-x-4">
                        <button type="submit" class="flex-1 bg-blue-600 text-white px-6 py-2 rounded-lg font-medium hover:bg-blue-700 transition-colors shadow-md">
                            Filtrar
                        </button>
                        <a href="<?= BASE_URL ?>/employees" class="flex-1 bg-gray-500 text-white px-6 py-2 rounded-lg font-medium hover:bg-gray-600 transition-colors shadow-md flex items-center justify-center">
                            Limpar
                        </a>
                    </div>
                </form>
            </div>

            <!-- Mensagens Aprimoradas -->
            <?php if (isset($_SESSION[
'success'
])): ?>
                <div class="mb-6 bg-green-50 border border-green-400 text-green-700 px-5 py-4 rounded-lg relative shadow-md" role="alert">
                    <span class="block sm:inline font-medium"><?= $_SESSION[
'success'
] ?></span>
                </div>
                <?php unset($_SESSION[
'success'
]); ?>
            <?php endif; ?>

            <?php if (isset($_SESSION[
'error'
])): ?>
                <div class="mb-6 bg-red-50 border border-red-400 text-red-700 px-5 py-4 rounded-lg relative shadow-md" role="alert">
                    <span class="block sm:inline font-medium"><?= $_SESSION[
'error'
] ?></span>
                </div>
                <?php unset($_SESSION[
'error'
]); ?>
            <?php endif; ?>

            <!-- Lista de Colaboradores Aprimorada -->
            <div class="bg-white rounded-2xl shadow-xl border border-gray-200">
                <div class="p-6 border-b border-gray-200">
                    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center">
                        <h2 class="text-2xl font-bold text-gray-900 mb-2 sm:mb-0">Lista de Colaboradores</h2>
                        <div class="text-base text-gray-600">
                            Total: <span class="font-semibold text-gray-800"><?= count($employees) ?></span> colaborador(es)
                        </div>
                    </div>
                </div>
            
                <?php if (empty($employees)): ?>
                    <div class="p-12 text-center bg-gray-50 rounded-b-2xl">
                        <div class="flex items-center justify-center w-16 h-16 bg-gray-100 rounded-full mx-auto mb-6 shadow-inner">
                            <svg class="w-8 h-8 text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                            </svg>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-3">Nenhum colaborador encontrado</h3>
                        <p class="text-gray-600 mb-8">Não há colaboradores cadastrados ou que atendam aos filtros aplicados. Comece adicionando um novo!</p>
                        <a href="<?= BASE_URL ?>/employees/create" class="inline-flex items-center px-8 py-3 bg-blue-600 text-white font-bold rounded-lg hover:bg-blue-700 transition-colors shadow-lg text-lg">
                            <svg class="w-6 h-6 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                            Cadastrar Primeiro Colaborador
                        </a>
                    </div>
                <?php else: ?>
                    <div class="p-6">
                        <div id="employees-grid" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                            <?php foreach ($employees as $employee): ?>
                                <div class="employee-card bg-gray-50 rounded-xl p-6 shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 border border-gray-100" 
                                     data-employee-id="<?= $employee[
'id'
] ?>" 
                                     data-status="<?= strtolower($employee[
'status'
]) ?>" 
                                     data-city="<?= strtolower($employee[
'city'
] ?? 
''
) ?>" 
                                     data-search="<?= strtolower($employee[
'full_name'
] . 
' '
 . $employee[
'cpf'
] . 
' '
 . ($employee[
'job_title'
] ?? 
''
)) ?>">
                                    
                                    <div class="flex items-start justify-between mb-5">
                                        <div class="flex items-center">
                                            <div class="w-14 h-14 bg-gradient-to-br from-blue-500 to-indigo-600 rounded-full flex items-center justify-center text-white font-bold text-xl shadow-inner">
                                                <?= strtoupper(substr($employee[
'full_name'
], 0, 2)) ?>
                                            </div>
                                            <div class="ml-4">
                                                <h3 class="font-bold text-lg text-gray-900"><?= htmlspecialchars($employee[
'full_name'
]) ?></h3>
                                                <p class="text-sm text-gray-600"><?= htmlspecialchars($employee[
'job_title'
] ?? 
'Cargo não informado'
) ?></p>
                                            </div>
                                        </div>
                                        <span class="px-4 py-1 text-xs font-semibold rounded-full <?= $employee[
'status'
] === 
'ativo'
 ? 
'bg-green-100 text-green-800'
 : ($employee[
'status'
] === 
'inativo'
 ? 
'bg-yellow-100 text-yellow-800'
 : 
'bg-red-100 text-red-800'
) ?>">
                                            <?= ucfirst($employee[
'status'
]) ?>
                                        </span>
                                    </div>
                                    
                                    <div class="space-y-3 mb-6">
                                        <div class="flex justify-between text-sm">
                                            <span class="text-gray-500">CPF:</span>
                                            <span class="text-gray-900 font-medium"><?= htmlspecialchars($employee[
'cpf'
]) ?></span>
                                        </div>
                                        
                                        <?php if (!empty($employee[
'city'
])): ?>
                                        <div class="flex justify-between text-sm">
                                            <span class="text-gray-500">Cidade:</span>
                                            <span class="text-gray-900 font-medium"><?= htmlspecialchars($employee[
'city'
]) ?></span>
                                        </div>
                                        <?php endif; ?>
                                        
                                        <?php if (!empty($employee[
'salary'
])): ?>
                                        <div class="flex justify-between text-sm">
                                            <span class="text-gray-500">Salário:</span>
                                            <span class="text-gray-900 font-medium">R$ <?= number_format($employee[
'salary'
], 2, 
','
, 
'.'
) ?></span>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <div class="flex space-x-3">
                                        <a href="<?= BASE_URL ?>/employees/<?= $employee[
'id'
] ?>" class="flex-1 bg-blue-600 text-white text-center py-2.5 px-3 rounded-lg text-sm font-medium hover:bg-blue-700 transition-colors shadow-sm">
                                            Ver Detalhes
                                        </a>
                                        <a href="<?= BASE_URL ?>/employees/<?= $employee[
'id'
] ?>/edit" class="flex-1 bg-yellow-500 text-white text-center py-2.5 px-3 rounded-lg text-sm font-medium hover:bg-yellow-600 transition-colors shadow-sm">
                                            Editar
                                        </a>
                                        <form action="<?= BASE_URL ?>/employees/<?= $employee[
'id'
] ?>/delete" method="POST" onsubmit="return confirm(
'Tem certeza que deseja excluir este colaborador?'
);" class="flex-1">
                                            <button type="submit" class="w-full bg-red-600 text-white text-center py-2.5 px-3 rounded-lg text-sm font-medium hover:bg-red-700 transition-colors shadow-sm">
                                                Excluir
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>

<?php include __DIR__ . 
'/../partials/footer.php
'; ?>
