<?php
require_once __DIR__ . '/../partials/header.php';
?>

<div class="min-h-screen bg-gray-50">
    <!-- Header -->
    <div class="bg-white shadow">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center py-6">
                <div>
                    <nav class="flex" aria-label="Breadcrumb">
                        <ol class="flex items-center space-x-4">
                            <li>
                                <a href="<?= BASE_URL ?>/employees" class="text-gray-400 hover:text-gray-500">
                                    <span class="sr-only">Colaboradores</span>
                                    <svg class="flex-shrink-0 h-5 w-5" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"></path>
                                    </svg>
                                </a>
                            </li>
                            <li>
                                <div class="flex items-center">
                                    <svg class="flex-shrink-0 h-5 w-5 text-gray-300" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                    <a href="<?= BASE_URL ?>/employees" class="ml-4 text-sm font-medium text-gray-500 hover:text-gray-700">Colaboradores</a>
                                </div>
                            </li>
                            <li>
                                <div class="flex items-center">
                                    <svg class="flex-shrink-0 h-5 w-5 text-gray-300" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="ml-4 text-sm font-medium text-gray-900"><?= htmlspecialchars($employee['full_name']) ?></span>
                                </div>
                            </li>
                        </ol>
                    </nav>
                    <div class="mt-2 flex items-center">
                        <div class="flex-shrink-0">
                            <div class="h-16 w-16 rounded-full bg-gray-300 flex items-center justify-center">
                                <span class="text-xl font-medium text-gray-700">
                                    <?= strtoupper(substr($employee['full_name'], 0, 2)) ?>
                                </span>
                            </div>
                        </div>
                        <div class="ml-4">
                            <h1 class="text-3xl font-bold text-gray-900"><?= htmlspecialchars($employee['full_name']) ?></h1>
                            <div class="flex items-center mt-1">
                                <p class="text-lg text-gray-600"><?= htmlspecialchars($employee['job_title']) ?></p>
                                <span class="ml-3 inline-flex items-center px-3 py-0.5 rounded-full text-sm font-medium
                                    <?php 
                                        switch($employee['status']) {
                                            case 'ativo':
                                                echo 'bg-green-100 text-green-800';
                                                break;
                                            case 'inativo':
                                                echo 'bg-yellow-100 text-yellow-800';
                                                break;
                                            case 'demitido':
                                                echo 'bg-red-100 text-red-800';
                                                break;
                                            default:
                                                echo 'bg-gray-100 text-gray-800';
                                        }
                                    ?>">
                                    <?= ucfirst($employee['status']) ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="flex space-x-3">
                    <a href="<?= BASE_URL ?>/employees/<?= $employee['id'] ?>/edit" 
                       class="inline-flex items-center px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        <svg class="-ml-1 mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                        </svg>
                        Editar
                    </a>
                    <button onclick="confirmDelete(<?= $employee['id'] ?>, '<?= htmlspecialchars($employee['full_name']) ?>')" 
                            class="inline-flex items-center px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500">
                        <svg class="-ml-1 mr-2 h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                        </svg>
                        Excluir
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <!-- Mensagens -->
        <?php if (isset($_SESSION['success'])): ?>
            <div class="mb-6 bg-green-50 border border-green-200 rounded-md p-4">
                <div class="flex">
                    <div class="flex-shrink-0">
                        <svg class="h-5 w-5 text-green-400" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                        </svg>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm font-medium text-green-800"><?= $_SESSION['success'] ?></p>
                    </div>
                </div>
            </div>
            <?php unset($_SESSION['success']); ?>
        <?php endif; ?>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Informações Principais -->
            <div class="lg:col-span-2 space-y-8">
                <!-- Dados Pessoais -->
                <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Dados Pessoais</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">Informações básicas do colaborador.</p>
                    </div>
                    <div class="border-t border-gray-200">
                        <dl>
                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Nome completo</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= htmlspecialchars($employee['full_name']) ?></dd>
                            </div>
                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">CPF</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= $employee['cpf'] ?></dd>
                            </div>
                            <?php if ($employee['rg']): ?>
                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">RG</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= htmlspecialchars($employee['rg']) ?></dd>
                            </div>
                            <?php endif; ?>
                            <?php if ($employee['birth_date']): ?>
                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Data de nascimento</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                                    <?= date('d/m/Y', strtotime($employee['birth_date'])) ?>
                                    <span class="text-gray-500">(<?= (new DateTime($employee['birth_date']))->diff(new DateTime())->y ?> anos)</span>
                                </dd>
                            </div>
                            <?php endif; ?>
                            <?php if ($employee['phone_number']): ?>
                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Telefone</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= htmlspecialchars($employee['phone_number']) ?></dd>
                            </div>
                            <?php endif; ?>
                            <?php if ($employee['address']): ?>
                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Endereço</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= nl2br(htmlspecialchars($employee['address'])) ?></dd>
                            </div>
                            <?php endif; ?>
                        </dl>
                    </div>
                </div>

                <!-- Dados Contratuais -->
                <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Dados Contratuais</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">Informações sobre o contrato de trabalho.</p>
                    </div>
                    <div class="border-t border-gray-200">
                        <dl>
                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Cargo</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= htmlspecialchars($employee['job_title']) ?></dd>
                            </div>
                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Salário</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2 font-semibold">R$ <?= number_format($employee['salary'], 2, ',', '.') ?></dd>
                            </div>
                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Data de admissão</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2">
                                    <?= date('d/m/Y', strtotime($employee['hire_date'])) ?>
                                    <span class="text-gray-500">(<?= (new DateTime($employee['hire_date']))->diff(new DateTime())->days ?> dias na empresa)</span>
                                </dd>
                            </div>
                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Tipo de contrato</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= htmlspecialchars($employee['contract_type']) ?></dd>
                            </div>
                            <?php if ($employee['cost_center']): ?>
                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Centro de custo</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= htmlspecialchars($employee['cost_center']) ?></dd>
                            </div>
                            <?php endif; ?>
                        </dl>
                    </div>
                </div>

                <!-- Dados Bancários -->
                <?php if ($employee['bank_name'] || $employee['agency_number'] || $employee['account_number']): ?>
                <div class="bg-white shadow overflow-hidden sm:rounded-lg">
                    <div class="px-4 py-5 sm:px-6">
                        <h3 class="text-lg leading-6 font-medium text-gray-900">Dados Bancários</h3>
                        <p class="mt-1 max-w-2xl text-sm text-gray-500">Informações para pagamento do salário.</p>
                    </div>
                    <div class="border-t border-gray-200">
                        <dl>
                            <?php if ($employee['bank_name']): ?>
                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Banco</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= htmlspecialchars($employee['bank_name']) ?></dd>
                            </div>
                            <?php endif; ?>
                            <?php if ($employee['agency_number']): ?>
                            <div class="bg-white px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Agência</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= htmlspecialchars($employee['agency_number']) ?></dd>
                            </div>
                            <?php endif; ?>
                            <?php if ($employee['account_number']): ?>
                            <div class="bg-gray-50 px-4 py-5 sm:grid sm:grid-cols-3 sm:gap-4 sm:px-6">
                                <dt class="text-sm font-medium text-gray-500">Conta</dt>
                                <dd class="mt-1 text-sm text-gray-900 sm:mt-0 sm:col-span-2"><?= htmlspecialchars($employee['account_number']) ?></dd>
                            </div>
                            <?php endif; ?>
                        </dl>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- Sidebar -->
            <div class="space-y-8">
                <!-- Estatísticas Rápidas -->
                <div class="bg-white shadow rounded-lg p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informações Rápidas</h3>
                    <div class="space-y-4">
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">Idade:</span>
                            <span class="text-sm font-medium text-gray-900">
                                <?= $employee['birth_date'] ? (new DateTime($employee['birth_date']))->diff(new DateTime())->y . ' anos' : 'N/A' ?>
                            </span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">Tempo na empresa:</span>
                            <span class="text-sm font-medium text-gray-900">
                                <?php 
                                    $diff = (new DateTime($employee['hire_date']))->diff(new DateTime());
                                    if ($diff->y > 0) {
                                        echo $diff->y . ' ano' . ($diff->y > 1 ? 's' : '') . ' e ' . $diff->m . ' mês' . ($diff->m != 1 ? 'es' : '');
                                    } elseif ($diff->m > 0) {
                                        echo $diff->m . ' mês' . ($diff->m != 1 ? 'es' : '') . ' e ' . $diff->d . ' dia' . ($diff->d != 1 ? 's' : '');
                                    } else {
                                        echo $diff->d . ' dia' . ($diff->d != 1 ? 's' : '');
                                    }
                                ?>
                            </span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-sm text-gray-500">Status:</span>
                            <span class="text-sm font-medium <?php 
                                switch($employee['status']) {
                                    case 'ativo': echo 'text-green-600'; break;
                                    case 'inativo': echo 'text-yellow-600'; break;
                                    case 'demitido': echo 'text-red-600'; break;
                                    default: echo 'text-gray-600';
                                }
                            ?>">
                                <?= ucfirst($employee['status']) ?>
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Documentos -->
                <div class="bg-white shadow rounded-lg p-6">
                    <div class="flex justify-between items-center mb-4">
                        <h3 class="text-lg font-medium text-gray-900">Documentos</h3>
                        <button onclick="document.getElementById('uploadModal').classList.remove('hidden')" 
                                class="text-blue-600 hover:text-blue-900 text-sm font-medium">
                            + Adicionar
                        </button>
                    </div>
                    
                    <?php
                    require_once __DIR__ . '/../../models/EmployeeDocument.php';
                    $documentModel = new EmployeeDocument();
                    $documents = $documentModel->getByEmployeeId($employee['id']);
                    
                    if (empty($documents)): ?>
                        <p class="text-sm text-gray-500 text-center py-4">Nenhum documento enviado</p>
                    <?php else: ?>
                        <div class="space-y-3">
                            <?php foreach ($documents as $document): ?>
                                <div class="flex items-center justify-between p-3 border border-gray-200 rounded-lg">
                                    <div class="flex items-center">
                                        <?php if (strpos($document['mime_type'], 'image/') === 0): ?>
                                            <svg class="h-5 w-5 text-green-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                            </svg>
                                        <?php else: ?>
                                            <svg class="h-5 w-5 text-gray-400 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                            </svg>
                                        <?php endif; ?>
                                        <div>
                                            <p class="text-sm font-medium text-gray-900"><?= htmlspecialchars($document['original_name']) ?></p>
                                            <p class="text-xs text-gray-500">
                                                <?= EmployeeDocument::formatFileSize($document['file_size']) ?> • 
                                                <?= date('d/m/Y H:i', strtotime($document['uploaded_at'])) ?>
                                            </p>
                                        </div>
                                    </div>
                                    <div class="flex items-center space-x-2">
                                        <a href="<?= BASE_URL ?>/employees/<?= $employee['id'] ?>/documents/<?= $document['id'] ?>/download" 
                                           class="text-blue-600 hover:text-blue-900 text-sm font-medium">
                                            Download
                                        </a>
                                        <button onclick="deleteDocument(<?= $document['id'] ?>)" 
                                                class="text-red-600 hover:text-red-800 text-sm font-medium">
                                            Excluir
                                        </button>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Ações Rápidas -->
                <div class="bg-white shadow rounded-lg p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Ações Rápidas</h3>
                    <div class="space-y-3">
                        <a href="<?= BASE_URL ?>/time-records/employee/<?= $employee['id'] ?>" 
                           class="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:bg-gray-50 rounded-md">
                            📅 Ver Registros de Ponto
                        </a>
                        <a href="<?= BASE_URL ?>/absences/employee/<?= $employee['id'] ?>" 
                           class="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:bg-gray-50 rounded-md">
                            🏖️ Ver Ausências
                        </a>
                        <a href="<?= BASE_URL ?>/payrolls/employee/<?= $employee['id'] ?>" 
                           class="block w-full text-left px-3 py-2 text-sm text-gray-700 hover:bg-gray-50 rounded-md">
                            💰 Ver Folhas de Pagamento
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal de Upload de Documento -->
<div id="uploadModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Enviar Documento</h3>
            <form method="POST" action="<?= BASE_URL ?>/employees/<?= $employee['id'] ?>/documents/upload" enctype="multipart/form-data">
                <div class="mb-4">
                    <label for="document" class="block text-sm font-medium text-gray-700 mb-2">Selecionar arquivo</label>
                    <input type="file" name="document" id="document" required 
                           accept=".pdf,.jpg,.jpeg,.png"
                           class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
                    <p class="mt-1 text-xs text-gray-500">PDF, JPG, PNG até 5MB</p>
                </div>
                <div class="flex justify-end space-x-3">
                    <button type="button" onclick="document.getElementById('uploadModal').classList.add('hidden')" 
                            class="px-4 py-2 bg-gray-500 text-white text-sm font-medium rounded-md hover:bg-gray-600">
                        Cancelar
                    </button>
                    <button type="submit" 
                            class="px-4 py-2 bg-blue-500 text-white text-sm font-medium rounded-md hover:bg-blue-600">
                        Enviar
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal de Confirmação de Exclusão -->
<div id="deleteModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3 text-center">
            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100">
                <svg class="h-6 w-6 text-red-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.964-.833-2.732 0L3.732 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                </svg>
            </div>
            <h3 class="text-lg font-medium text-gray-900 mt-2">Confirmar Exclusão</h3>
            <div class="mt-2 px-7 py-3">
                <p class="text-sm text-gray-500" id="deleteMessage"></p>
            </div>
            <div class="items-center px-4 py-3">
                <form id="deleteForm" method="POST" class="inline">
                    <button type="submit" 
                            class="px-4 py-2 bg-red-500 text-white text-base font-medium rounded-md w-24 mr-2 hover:bg-red-600">
                        Excluir
                    </button>
                </form>
                <button onclick="closeDeleteModal()" 
                        class="px-4 py-2 bg-gray-500 text-white text-base font-medium rounded-md w-24 hover:bg-gray-600">
                    Cancelar
                </button>
            </div>
        </div>
    </div>
</div>

<script>
function confirmDelete(employeeId, employeeName) {
    document.getElementById('deleteMessage').textContent = 
        `Tem certeza que deseja excluir o colaborador "${employeeName}"? Esta ação não pode ser desfeita.`;
    
    document.getElementById('deleteForm').action = `<?= BASE_URL ?>/employees/${employeeId}/delete`;
    document.getElementById('deleteModal').classList.remove('hidden');
}

function closeDeleteModal() {
    document.getElementById('deleteModal').classList.add('hidden');
}

function deleteDocument(documentId) {
    if (confirm('Tem certeza que deseja excluir este documento?')) {
        // Criar formulário para enviar requisição DELETE
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '<?= BASE_URL ?>/employees/<?= $employee['id'] ?>/documents/' + documentId + '/delete';
        
        // Adicionar campo hidden para simular DELETE
        const methodField = document.createElement('input');
        methodField.type = 'hidden';
        methodField.name = '_method';
        methodField.value = 'DELETE';
        form.appendChild(methodField);
        
        document.body.appendChild(form);
        form.submit();
    }
}

// Fechar modais ao clicar fora
document.getElementById('deleteModal').addEventListener('click', function(e) {
    if (e.target === this) {
        closeDeleteModal();
    }
});

document.getElementById('uploadModal').addEventListener('click', function(e) {
    if (e.target === this) {
        this.classList.add('hidden');
    }
});
</script>

<?php require_once __DIR__ . '/../partials/footer.php'; ?>