<?php
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../helpers/AuthHelper.php';

AuthHelper::check();

$pageTitle = "Recursos Humanos";
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body class="bg-gray-100">
    <?php include __DIR__ . '/../partials/header.php'; ?>

    <div class="container mx-auto px-4 py-8">
        <!-- Cabeçalho -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-8">
            <div class="flex items-center justify-between mb-4">
                <div>
                    <h1 class="text-3xl font-bold text-gray-800 mb-2">
                        <i class="fas fa-users text-blue-600 mr-3"></i>
                        Recursos Humanos
                    </h1>
                    <p class="text-gray-600">Gerencie colaboradores, controle de ponto e folha de pagamento</p>
                </div>
                <a href="<?= BASE_URL ?>" class="bg-gray-500 hover:bg-gray-600 text-white px-4 py-2 rounded-lg transition duration-200 flex items-center">
                    <i class="fas fa-arrow-left mr-2"></i>
                    Voltar
                </a>
            </div>
        </div>

        <!-- Cards dos Módulos -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- Colaboradores -->
            <div class="bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center">
                            <div class="bg-blue-100 p-3 rounded-full">
                                <i class="fas fa-user-tie text-blue-600 text-xl"></i>
                            </div>
                            <h3 class="text-xl font-semibold text-gray-800 ml-3">Colaboradores</h3>
                        </div>
                    </div>
                    <p class="text-gray-600 mb-4">Cadastre e gerencie informações dos colaboradores, documentos e dados pessoais.</p>
                    <div class="flex flex-col space-y-2">
                        <a href="<?= BASE_URL ?>/employees" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors text-center">
                            <i class="fas fa-users mr-2"></i>Gerenciar Colaboradores
                        </a>
                        <a href="<?= BASE_URL ?>/employees/create" class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors text-center">
                            <i class="fas fa-user-plus mr-2"></i>Novo Colaborador
                        </a>
                    </div>
                </div>
            </div>

            <!-- Controle de Ponto -->
            <div class="bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center">
                            <div class="bg-green-100 p-3 rounded-full">
                                <i class="fas fa-clock text-green-600 text-xl"></i>
                            </div>
                            <h3 class="text-xl font-semibold text-gray-800 ml-3">Controle de Ponto</h3>
                        </div>
                    </div>
                    <p class="text-gray-600 mb-4">Monitore entrada, saída e pausas dos colaboradores em tempo real.</p>
                    <div class="flex flex-col space-y-2">
                        <a href="<?= BASE_URL ?>/time-records" class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors text-center">
                            <i class="fas fa-list mr-2"></i>Ver Registros
                        </a>
                        <a href="<?= BASE_URL ?>/time-records/clock" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors text-center">
                            <i class="fas fa-clock mr-2"></i>Bater Ponto
                        </a>
                        <a href="<?= BASE_URL ?>/time-records/report" class="bg-purple-600 text-white px-4 py-2 rounded-md hover:bg-purple-700 transition-colors text-center">
                            <i class="fas fa-chart-bar mr-2"></i>Relatórios
                        </a>
                    </div>
                </div>
            </div>

            <!-- Folha de Pagamento -->
            <div class="bg-white rounded-lg shadow-md hover:shadow-lg transition-shadow duration-300">
                <div class="p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center">
                            <div class="bg-yellow-100 p-3 rounded-full">
                                <i class="fas fa-money-check-alt text-yellow-600 text-xl"></i>
                            </div>
                            <h3 class="text-xl font-semibold text-gray-800 ml-3">Folha de Pagamento</h3>
                        </div>
                    </div>
                    <p class="text-gray-600 mb-4">Gerencie salários, descontos, benefícios e gere holerites dos colaboradores.</p>
                    <div class="flex flex-col space-y-2">
                        <a href="<?= BASE_URL ?>/payrolls" class="bg-yellow-600 text-white px-4 py-2 rounded-md hover:bg-yellow-700 transition-colors text-center">
                            <i class="fas fa-list mr-2"></i>Ver Folhas
                        </a>
                        <a href="<?= BASE_URL ?>/payrolls/create" class="bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 transition-colors text-center">
                            <i class="fas fa-plus mr-2"></i>Nova Folha
                        </a>
                        <a href="<?= BASE_URL ?>/payrolls/generate-batch" class="bg-blue-600 text-white px-4 py-2 rounded-md hover:bg-blue-700 transition-colors text-center">
                            <i class="fas fa-cogs mr-2"></i>Gerar em Lote
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estatísticas Rápidas -->
        <div class="mt-8 grid grid-cols-1 md:grid-cols-4 gap-4">
            <div class="bg-white p-4 rounded-lg shadow">
                <div class="flex items-center">
                    <div class="bg-blue-100 p-2 rounded-full">
                        <i class="fas fa-users text-blue-600"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-gray-600">Total Colaboradores</p>
                        <p class="text-xl font-semibold text-gray-800" id="total-employees">-</p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white p-4 rounded-lg shadow">
                <div class="flex items-center">
                    <div class="bg-green-100 p-2 rounded-full">
                        <i class="fas fa-user-check text-green-600"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-gray-600">Presentes Hoje</p>
                        <p class="text-xl font-semibold text-gray-800" id="present-today">-</p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white p-4 rounded-lg shadow">
                <div class="flex items-center">
                    <div class="bg-yellow-100 p-2 rounded-full">
                        <i class="fas fa-money-bill-wave text-yellow-600"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-gray-600">Folhas Este Mês</p>
                        <p class="text-xl font-semibold text-gray-800" id="payrolls-month">-</p>
                    </div>
                </div>
            </div>
            
            <div class="bg-white p-4 rounded-lg shadow">
                <div class="flex items-center">
                    <div class="bg-purple-100 p-2 rounded-full">
                        <i class="fas fa-clock text-purple-600"></i>
                    </div>
                    <div class="ml-3">
                        <p class="text-sm text-gray-600">Horas Hoje</p>
                        <p class="text-xl font-semibold text-gray-800" id="hours-today">-</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Carregar estatísticas básicas
        document.addEventListener('DOMContentLoaded', function() {
            // Fazer chamada AJAX para carregar estatísticas
            fetch('<?= BASE_URL ?>/rh/stats')
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        document.getElementById('total-employees').textContent = data.data.total_employees;
                        document.getElementById('present-today').textContent = data.data.present_today;
                        document.getElementById('payrolls-month').textContent = data.data.payrolls_month;
                        document.getElementById('hours-today').textContent = data.data.hours_today;
                    } else {
                        console.error('Erro ao carregar estatísticas:', data.message);
                        // Manter valores padrão em caso de erro
                        document.getElementById('total-employees').textContent = '0';
                        document.getElementById('present-today').textContent = '0';
                        document.getElementById('payrolls-month').textContent = '0';
                        document.getElementById('hours-today').textContent = '0h';
                    }
                })
                .catch(error => {
                    console.error('Erro na requisição:', error);
                    // Manter valores padrão em caso de erro
                    document.getElementById('total-employees').textContent = '0';
                    document.getElementById('present-today').textContent = '0';
                    document.getElementById('payrolls-month').textContent = '0';
                    document.getElementById('hours-today').textContent = '0h';
                });
        });
    </script>
</body>
</html>