<?php
// O session_start() já é chamado no roteador principal (index.php)
// ou no próprio controller, então não é necessário aqui.
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Login - Gestão de Gabinete' ?></title>
    <link rel="stylesheet" href="<?= BASE_URL ?>/public/css/styles.css">
    <style>
        body { display: flex; justify-content: center; align-items: center; height: 100vh; background-color: #f4f4f4; margin: 0; font-family: sans-serif; }
        .login-container { padding: 40px; background: white; border-radius: 8px; box-shadow: 0 4px 10px rgba(0,0,0,0.1); width: 100%; max-width: 400px; }
        .login-container h1 { text-align: center; margin-bottom: 20px; color: #333; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; color: #555; }
        .form-group input { box-sizing: border-box; width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 4px; }
        .btn-submit { width: 100%; padding: 12px; background-color: #337ab7; color: white; border: none; border-radius: 4px; cursor: pointer; font-size: 16px; font-weight: bold; }
        .btn-submit:hover { background-color: #286090; }
        .error-message { color: #a94442; background-color: #f2dede; border: 1px solid #ebccd1; padding: 10px; border-radius: 4px; margin-bottom: 15px; text-align: center; }
    </style>
</head>
<body>
    <div class="login-container">
        <h1>Acessar Sistema</h1>

        <?php
        // Mostra a mensagem de erro, se houver uma na sessão.
        if (isset($_SESSION['erro_login'])) {
            echo '<div class="error-message">' . $_SESSION['erro_login'] . '</div>';
            // Limpa a mensagem da sessão para não mostrar de novo na próxima vez.
            unset($_SESSION['erro_login']); 
        }

        // --- Adicionado para exibir mensagem de acesso não autorizado ---
        if (isset($_GET['unauthorized']) && $_GET['unauthorized'] == 1) {
            echo '<div class="error-message">Acesso não autorizado. Por favor, faça login para continuar.</div>';
        }
        ?>

        <form action="<?= BASE_URL ?>/usuario/processarLogin" method="post">
            <div class="form-group">
                <label for="email">E-mail:</label>
                <input type="email" id="email" name="email" required>
            </div>
            <div class="form-group">
                <label for="senha">Senha:</label>
                <input type="password" id="senha" name="senha" required>
            </div>
            <button type="submit" class="btn-submit">Entrar</button>
        </form>
    </div>
</body>
</html>