<?php
session_start();
require_once 'src/config/config.php';
require_once 'src/helpers/AuthHelper.php';

// Simula login se não estiver logado
if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
    $_SESSION['logado'] = true;
    $_SESSION['usuario_id'] = 2;
    $_SESSION['usuario_nome'] = 'admin';
    $_SESSION['usuario_email'] = 'admin@gabinete.com';
    $_SESSION['usuario_nivel'] = 'Admin';
}

echo "<h1>Teste de Roteamento</h1>";
echo "<p>Status da sessão: " . (isset($_SESSION['logado']) && $_SESSION['logado'] ? '✅ Logado' : '❌ Não logado') . "</p>";
echo "<p>Session ID: " . session_id() . "</p>";
echo "<p>Usuário: " . ($_SESSION['usuario_nome'] ?? 'N/A') . "</p>";

// Testa diferentes rotas
$routes = [
    'documentos' => 'DocumentosController',
    'eleitores' => 'EleitoresController', 
    'agendas' => 'AgendasController',
    'relatorios' => 'RelatoriosController',
    'configuracoes' => 'ConfiguracoesController'
];

echo "<h2>Teste de Controllers:</h2>";
foreach ($routes as $route => $controller) {
    $controllerFile = 'src/controllers/' . $controller . '.php';
    $exists = file_exists($controllerFile);
    $status = $exists ? '✅' : '❌';
    echo "<p>{$status} {$route} → {$controller} (" . ($exists ? 'Existe' : 'Não existe') . ")</p>";
    
    if ($exists) {
        require_once $controllerFile;
        if (class_exists($controller)) {
            $instance = new $controller();
            $hasIndex = method_exists($instance, 'index');
            echo "<p style='margin-left: 20px;'>" . ($hasIndex ? '✅' : '❌') . " Método index() " . ($hasIndex ? 'existe' : 'não existe') . "</p>";
        }
    }
}

echo "<h2>Links de Teste Direto:</h2>";
foreach ($routes as $route => $controller) {
    echo "<p><a href='http://localhost:8888/gabinete/{$route}' target='_blank'>🔗 Testar /{$route}</a></p>";
}

echo "<h2>Informações de Debug:</h2>";
echo "<p>BASE_URL: " . BASE_URL . "</p>";
echo "<p>REQUEST_URI: " . ($_SERVER['REQUEST_URI'] ?? 'N/A') . "</p>";
echo "<p>HTTP_HOST: " . ($_SERVER['HTTP_HOST'] ?? 'N/A') . "</p>";
?>