<?php
require_once 'src/config/config.php';

echo "<h1>Debug Insert Usuário</h1>";

try {
    $pdo = new PDO('mysql:host=' . DB_HOST . ';dbname=' . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    echo "<p>Conexão OK.</p>";

    // Tenta inserir um usuário de teste (com timestamp para ser único)
    $email = 'teste_' . time() . '@exemplo.com';
    $senha = password_hash('123456', PASSWORD_DEFAULT);

    // Tenta usar o nome de coluna NOVO (nivel_acesso)
    $sql = "INSERT INTO usuarios (nome, email, senha, nivel_acesso, ativo) VALUES ('Teste Debug', :email, :senha, 'Assessor', 1)";

    echo "<p>Tentando executar: <code>$sql</code></p>";

    $stmt = $pdo->prepare($sql);
    $stmt->execute(['email' => $email, 'senha' => $senha]);

    echo "<h2 style='color:green'>SUCESSO! Usuário inserido.</h2>";
    echo "<p>ID: " . $pdo->lastInsertId() . "</p>";

} catch (PDOException $e) {
    echo "<h2 style='color:red'>ERRO PDO:</h2>";
    echo "<pre>" . $e->getMessage() . "</pre>";

    // Se der erro, verifica as colunas novamente para confirmar
    echo "<h3>Colunas na tabela:</h3>";
    try {
        $stmt = $pdo->query("DESCRIBE usuarios");
        $cols = $stmt->fetchAll(PDO::FETCH_COLUMN);
        echo "<pre>" . implode(", ", $cols) . "</pre>";
    } catch (Exception $ex) {
        echo "Erro ao listar colunas: " . $ex->getMessage();
    }
}
