<?php
// debug_report.php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
// Mock session for AuthHelper
$_SESSION['user_id'] = 1;
$_SESSION['nivel_acesso'] = 'Admin';
$_SESSION['nome'] = 'Debug User';

require_once __DIR__ . '/src/config/config.php';
require_once __DIR__ . '/src/controllers/RelatoriosController.php';

echo "Controller loaded.\n";

try {
    $controller = new RelatoriosController();
    echo "Controller instantiated.\n";

    // Mocking the view inclusion by overriding require_once behavior? 
    // No, we can't easily do that. But if it fails inside, we'll see the error.

    // We can't fully run porUsuario because it requires the view file which outputs HTML.
    // But we can check if getContagemPorUsuario works.

    $model = new Relatorio();
    echo "Model instantiated.\n";

    $dados = $model->getContagemPorUsuario();
    echo "Data fetched: " . count($dados) . " rows.\n";
    print_r($dados);

    echo "Calling controller method...\n";
    // This will output HTML, which is fine for debugging
    $controller->porUsuario();

} catch (Throwable $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo $e->getTraceAsString();
}
