-- ============================================================
-- GABINETE DB - Banco de Dados Corrigido para MySQL 8.0
-- Gerado: 2025-11-12
-- ============================================================
-- CORREÇÕES APLICADAS:
-- 1. Sintaxe ENUM corrigida com aspas
-- 2. Nomes de banco de dados consolidados
-- 3. Removídos scripts conflitantes
-- 4. Garante transacao segura
-- ============================================================

!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT;
!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS;
!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION;
!40101 SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS=0;
START TRANSACTION;

-- CRIAR BANCO DE DADOS
CREATE DATABASE IF NOT EXISTS `aurydona_gabinete_db`
CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

USE `aurydona_gabinete_db`;

-- ============================================================
-- TABELA 1: USUARIOS DO SISTEMA
-- ============================================================
CREATE TABLE IF NOT EXISTS `usuarios` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `nome` VARCHAR(150) NOT NULL,
  `email` VARCHAR(150) NOT NULL UNIQUE,
  `senha` VARCHAR(255) NOT NULL COMMENT 'Hash da senha',
  `nivelacesso` ENUM('Admin','AgendaFinanceiroDocumentos','EleitorDocumentos','DocumentosFinanceiroRH','AcessoTotal') NOT NULL DEFAULT 'EleitorDocumentos',
  `ativo` BOOLEAN NOT NULL DEFAULT TRUE,
  `datacriacao` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `dataatualizacao` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  ENGINE=InnoDB,
  CHARSET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ============================================================
-- TABELA 2: ELEITORES
-- ============================================================
CREATE TABLE IF NOT EXISTS `eleitores` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `nomecompleto` VARCHAR(255) NOT NULL,
  `cpf` VARCHAR(14) UNIQUE,
  `datanascimento` DATE,
  `sexo` ENUM('Masculino','Feminino','Outro') DEFAULT NULL,
  `telefone` VARCHAR(20),
  `email` VARCHAR(255),
  `endereco` VARCHAR(255),
  `bairro` VARCHAR(100),
  `cidade` VARCHAR(100) DEFAULT 'Belém',
  `cep` VARCHAR(9),
  `tipo` ENUM('Apoiador','Liderança','Neutral') DEFAULT 'Apoiador',
  `demanda` VARCHAR(100),
  `observacao` TEXT,
  `datacadastro` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  ENGINE=InnoDB,
  CHARSET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ============================================================
-- TABELA 3: DEMANDAS
-- ============================================================
CREATE TABLE IF NOT EXISTS `demandas` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `ideleitor` INT NOT NULL,
  `titulo` VARCHAR(255) NOT NULL,
  `descricao` TEXT NOT NULL,
  `categoria` VARCHAR(100) COMMENT 'Ex: Saúde, Educação, Infraestrutura',
  `status` ENUM('Aberta','Em Andamento','Concluda','Cancelada') NOT NULL DEFAULT 'Aberta',
  `dataabertura` DATE NOT NULL,
  `dataconclusao` DATE,
  `idresponsavel` INT COMMENT 'ID do usuário responsável',
  `datacriacao` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (`ideleitor`) REFERENCES `eleitores`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`idresponsavel`) REFERENCES `usuarios`(`id`) ON DELETE SET NULL,
  ENGINE=InnoDB,
  CHARSET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ============================================================
-- TABELA 9: EMPLOYEES (COLABORADORES/RH)
-- ============================================================
CREATE TABLE IF NOT EXISTS `employees` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `fullname` VARCHAR(255) NOT NULL,
  `cpf` VARCHAR(14) UNIQUE NOT NULL,
  `rg` VARCHAR(20) NOT NULL,
  `birthdate` DATE NOT NULL,
  `address` TEXT NOT NULL,
  `city` VARCHAR(100),
  `state` VARCHAR(50),
  `postalcode` VARCHAR(10),
  `phonenumber` VARCHAR(20) NOT NULL,
  `jobtitle` VARCHAR(100) NOT NULL,
  `salary` DECIMAL(10,2) NOT NULL,
  `hiredate` DATE NOT NULL,
  `contracttype` ENUM('CLT','PJ','Estagiário','Terceirizado') NOT NULL DEFAULT 'CLT',
  `costcenter` VARCHAR(100),
  `department` VARCHAR(100),
  `worklocation` VARCHAR(255),
  `photo` VARCHAR(255),
  `bankname` VARCHAR(100) NOT NULL,
  `agencynumber` VARCHAR(20) NOT NULL,
  `accountnumber` VARCHAR(30) NOT NULL,
  `status` ENUM('ativo','inativo','demitido') NOT NULL DEFAULT 'ativo',
  `createdat` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updatedat` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  ENGINE=InnoDB,
  CHARSET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ============================================================
-- TABELA 10: TIME RECORDS (PONTO ELETRONICO)
-- ============================================================
CREATE TABLE IF NOT EXISTS `timerecords` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `employeeid` INT NOT NULL,
  `workdate` DATE NOT NULL,
  `entrytime` TIME NOT NULL,
  `exittime` TIME,
  `totalhours` DECIMAL(4,2),
  `overtimehours` DECIMAL(4,2) DEFAULT 0,
  `notes` TEXT,
  `createdat` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updatedat` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (`employeeid`) REFERENCES `employees`(`id`) ON DELETE CASCADE,
  UNIQUE KEY `unique_employee_date` (`employeeid`,`workdate`),
  ENGINE=InnoDB,
  CHARSET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ============================================================
-- TABELA 11: ABSENCES (AUSENCIAS)
-- ============================================================
CREATE TABLE IF NOT EXISTS `absences` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `employeeid` INT NOT NULL,
  `startdate` DATE NOT NULL,
  `enddate` DATE NOT NULL,
  `absencetype` ENUM('férias','licença médica','atestado','falta justificada','falta injustificada') NOT NULL,
  `reason` TEXT,
  `dayscount` INT NOT NULL,
  `approved` BOOLEAN DEFAULT FALSE,
  `createdat` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `updatedat` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (`employeeid`) REFERENCES `employees`(`id`) ON DELETE CASCADE,
  ENGINE=InnoDB,
  CHARSET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ============================================================
-- TABELA 12: PAYROLLS (FOLHA DE PAGAMENTO)
-- ============================================================
CREATE TABLE IF NOT EXISTS `payrolls` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `employeeid` INT NOT NULL,
  `referencemonth` INT NOT NULL,
  `referenceyear` INT NOT NULL,
  `basesalary` DECIMAL(10,2) NOT NULL,
  `overtimeamount` DECIMAL(10,2) DEFAULT 0,
  `totalearnings` DECIMAL(10,2) NOT NULL,
  `inssdiscount` DECIMAL(10,2) DEFAULT 0,
  `irrfdiscount` DECIMAL(10,2) DEFAULT 0,
  `transportdiscount` DECIMAL(10,2) DEFAULT 0,
  `mealdiscount` DECIMAL(10,2) DEFAULT 0,
  `absencediscount` DECIMAL(10,2) DEFAULT 0,
  `totaldiscounts` DECIMAL(10,2) NOT NULL,
  `netsalary` DECIMAL(10,2) NOT NULL,
  `workeddays` INT NOT NULL,
  `absencedays` INT DEFAULT 0,
  `overtimehours` DECIMAL(4,2) DEFAULT 0,
  `generatedat` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  FOREIGN KEY (`employeeid`) REFERENCES `employees`(`id`) ON DELETE CASCADE,
  UNIQUE KEY `unique_employee_period` (`employeeid`,`referencemonth`,`referenceyear`),
  ENGINE=InnoDB,
  CHARSET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ============================================================
-- TABELA 13: MATERIAL PUBLICITARIO
-- ============================================================
CREATE TABLE IF NOT EXISTS `materialpublicitario` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `idusuario` INT NOT NULL,
  `titulo` VARCHAR(255) NOT NULL,
  `descricao` TEXT,
  `nomearquivo` VARCHAR(255) NOT NULL,
  `caminhoarquivo` VARCHAR(500) NOT NULL,
  `tipoarquivo` VARCHAR(100) NOT NULL,
  `tamanhoarquivo` BIGINT NOT NULL,
  `categoria` ENUM('Banner Digital','Cartaz Impresso','Flyer','Post Redes Sociais','Vídeo Promocional','Spot Rádio','Material TV','Outdoor','Busdoor','Adesivo','Santinho','Folder','Panfleto','Outros') NOT NULL DEFAULT 'Outros',
  `tipomidia` ENUM('imagem','video','audio','documento') NOT NULL DEFAULT 'documento',
  `largura` INT,
  `altura` INT,
  `duracao` INT,
  `thumbnail` VARCHAR(255),
  `campanha` VARCHAR(255),
  `evento` VARCHAR(255),
  `dataevento` DATE,
  `publicoalvo` VARCHAR(255),
  `tags` TEXT,
  `corpredominante` VARCHAR(50),
  `formatofinal` VARCHAR(100),
  `status` ENUM('rascunho','aprovado','publicado','arquivado') DEFAULT 'rascunho',
  `aprovadopor` INT,
  `dataaprovacao` DATETIME,
  `visualizacoes` INT DEFAULT 0,
  `downloads` INT DEFAULT 0,
  `dataupload` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  `dataatualizacao` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  FOREIGN KEY (`idusuario`) REFERENCES `usuarios`(`id`) ON DELETE CASCADE,
  FOREIGN KEY (`aprovadopor`) REFERENCES `usuarios`(`id`) ON DELETE SET NULL,
  INDEX `idx_categoria` (`categoria`),
  INDEX `idx_tipomidia` (`tipomidia`),
  INDEX `idx_campanha` (`campanha`),
  INDEX `idx_status` (`status`),
  ENGINE=InnoDB,
  CHARSET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ============================================================
-- TABELA 14: TRANSACOES (CONTAS)
-- ============================================================
CREATE TABLE IF NOT EXISTS `transacoes` (
  `id` INT AUTO_INCREMENT PRIMARY KEY,
  `datatransacao` DATE NOT NULL,
  `tipo` ENUM('Receita','Despesa') NOT NULL,
  `descricao` VARCHAR(255) NOT NULL,
  `valor` DECIMAL(10,2) NOT NULL,
  `categoria` VARCHAR(100),
  `formapagamento` VARCHAR(100),
  `entidade` VARCHAR(150),
  `origem` VARCHAR(100),
  `datacriacao` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  ENGINE=InnoDB,
  CHARSET utf8mb4 COLLATE utf8mb4_general_ci
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ============================================================
-- INSERT: USUARIO ADMIN PADRAO
-- ============================================================
INSERT INTO `usuarios` (`nome`, `email`, `senha`, `nivelacesso`, `ativo`) 
VALUES 
  ('Administrador', 'admin@gabinete.com', '$2y$10$3PzQE2gJ.D5kR2l.L8l3u6z.sXfP1JzF0bX.aB.iW.eNqG.zG2G', 'Admin', 1);

-- ============================================================
-- INSERT: PERMISSÕES POR NÍVEL
-- ============================================================
INSERT INTO `niveisacessopermissoes` (`nivelacesso`, `modulo`, `podevisualizar`, `podecriar`, `podeeditar`, `podeexcluir`) VALUES
-- Admin - Acesso Total
('Admin', 'agendas', 1, 1, 1, 1),
('Admin', 'documentos', 1, 1, 1, 1),
('Admin', 'eleitores', 1, 1, 1, 1),
('Admin', 'contas', 1, 1, 1, 1),
('Admin', 'rh', 1, 1, 1, 1),
('Admin', 'materialpublicitario', 1, 1, 1, 1),
('Admin', 'relatorios', 1, 1, 1, 1),
('Admin', 'admin', 1, 1, 1, 1),
('Admin', 'configuracoes', 1, 1, 1, 1),
-- AgendaFinanceiroDocumentos
('AgendaFinanceiroDocumentos', 'agendas', 1, 1, 1, 1),
('AgendaFinanceiroDocumentos', 'documentos', 1, 1, 1, 1),
('AgendaFinanceiroDocumentos', 'contas', 1, 1, 1, 1),
('AgendaFinanceiroDocumentos', 'eleitores', 0, 0, 0, 0),
('AgendaFinanceiroDocumentos', 'rh', 0, 0, 0, 0),
-- EleitorDocumentos
('EleitorDocumentos', 'eleitores', 1, 1, 1, 1),
('EleitorDocumentos', 'documentos', 1, 1, 1, 1),
('EleitorDocumentos', 'agendas', 0, 0, 0, 0),
-- DocumentosFinanceiroRH
('DocumentosFinanceiroRH', 'documentos', 1, 1, 1, 1),
('DocumentosFinanceiroRH', 'contas', 1, 1, 1, 1),
('DocumentosFinanceiroRH', 'rh', 1, 1, 1, 1),
-- AcessoTotal
('AcessoTotal', 'agendas', 1, 1, 1, 1),
('AcessoTotal', 'documentos', 1, 1, 1, 1),
('AcessoTotal', 'eleitores', 1, 1, 1, 1),
('AcessoTotal', 'contas', 1, 1, 1, 1),
('AcessoTotal', 'rh', 1, 1, 1, 1),
('AcessoTotal', 'materialpublicitario', 1, 1, 1, 1),
('AcessoTotal', 'relatorios', 1, 1, 1, 1);

-- ============================================================
-- INSERT: CONFIGURAÇÕES PADRÃO WHATSAPP
-- ============================================================
INSERT INTO `configuracoessistema` (`chave`, `valor`, `descricao`, `tipo`) VALUES
('whatsapp_ativo', '0', 'Ativar notificações WhatsApp', 'boolean'),
('whatsapp_apiprovider', 'twilio', 'Provedor API WhatsApp (twilio/ultramsg)', 'select'),
('whatsapp_template_compromisso', 'Olá! Lembrete: Você tem um compromisso agendado para {data} às {hora}.', 'Template notificação', 'texto'),
('whatsapp_antecedencia_horas', '2', 'Horas antes para enviar notificação', 'numero'),
('whatsapp_horario_inicio', '08:00', 'Horário mínimo envio', 'texto'),
('whatsapp_horario_fim', '20:00', 'Horário máximo envio', 'texto');

-- ============================================================
-- COMMIT TRANSACAO
-- ============================================================
COMMIT;
SET FOREIGN_KEY_CHECKS=1;

-- ============================================================
-- FIM DO SCRIPT
-- ============================================================
-- Status: Banco de dados criado com sucesso!
-- Banco: aurydona_gabinete_db
-- Tabelas criadas: 14
-- Usuários inseridos: 1 (admin@gabinete.com)
-- ============================================================