<?php
/**
 * Login - GABINETE Sistema Municipal
 * Autenticação de Usuários
 */

session_start();

// Corrige o caminho do config.php!
$config = require __DIR__ . '/src/config/config.php';

$erro = '';
$email = '';

// Verifica se já está logado
if (!empty($_SESSION['user_id'])) {
    header('Location: ' . BASE_URL . '/src/views/dashboard/index.php');
    exit;
}

// Processa envio do formulário
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = isset($_POST['email']) ? trim($_POST['email']) : '';
    $senha = isset($_POST['senha']) ? $_POST['senha'] : '';

    // Validação básica
    if (empty($email) || empty($senha)) {
        $erro = 'Email e senha são obrigatórios';
    } else {
        $pdo = null;
        try {
            // Conexão com banco via PDO
            $pdo = new PDO(
                "mysql:host={$config['database']['host']};port={$config['database']['port']};dbname={$config['database']['database']};charset={$config['database']['charset']}",
                $config['database']['username'],
                $config['database']['password'],
                [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
            );

            // Query preparada
            $stmt = $pdo->prepare('SELECT * FROM usuarios WHERE email = ? AND ativo = 1');
            $stmt->execute([$email]);
            $usuario = $stmt->fetch(PDO::FETCH_ASSOC);

            // Verifica usuário e senha
            if ($usuario && password_verify($senha, $usuario['senha'])) {
                $_SESSION['user_id'] = $usuario['id'];
                $_SESSION['usuario_id'] = $usuario['id']; // Compatibilidade com AuthHelper
                $_SESSION['logado'] = true; // Compatibilidade com AuthHelper
                $_SESSION['nome'] = $usuario['nome'];
                $_SESSION['email'] = $usuario['email'];
                $_SESSION['nivel_acesso'] = $usuario['nivel_acesso'];

                $pdo = null; // Fecha conexão PDO

                header('Location: ' . BASE_URL . '/src/views/dashboard/index.php');
                exit;
            } else {
                $erro = 'Email ou senha inválidos';
            }

        } catch (PDOException $e) {
            error_log('Erro PDO: ' . $e->getMessage());
            $erro = 'Erro de conexão com o banco de dados';
        } catch (Exception $e) {
            error_log('Erro geral: ' . $e->getMessage());
            $erro = 'Erro no sistema';
        } finally {
            $pdo = null; // Garante fechamento da conexão
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - GABINETE</title>
    <link rel="icon" href="public/images/favicon.png" type="image/png">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;

            /* * ==========================================================
             * AQUI É ONDE VOCÊ MUDA A COR DO FUNDO (BACKGROUND)
             * ==========================================================
             * Agora está definido com a cor única rosa (#ec22a3).
             * Para mudar, basta alterar o código hexadecimal abaixo.
             */
            background: #ec22a3;

            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }

        .login-container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            width: 100%;
            max-width: 400px;
        }

        .logo {
            text-align: center;
            margin-bottom: 30px;
        }

        .logo h1 {
            color: #333;
            font-size: 28px;
            margin-bottom: 5px;
        }

        .logo p {
            color: #666;
            font-size: 14px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }

        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
            transition: border-color 0.3s;
        }

        input[type="email"]:focus,
        input[type="password"]:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }

        .error {
            color: #dc3545;
            margin-bottom: 15px;
            padding: 12px;
            background: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 5px;
            font-size: 14px;
        }

        button {
            width: 100%;
            padding: 12px;
            /* Alterado para a cor azul solicitada (#1800ad) */
            background: #1800ad;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            font-weight: 600;
        }

        button:hover {
            opacity: 0.9;
        }

        .footer {
            text-align: center;
            margin-top: 20px;
            color: #666;
            font-size: 12px;
        }
    </style>
</head>

<body>
    <div class="login-container">
        <div class="logo">
            <h1>GABINETE</h1>
            <p>Sistema Gestão de Gabinetes</p>
        </div>

        <?php if ($erro): ?>
            <div class="error"><?= htmlspecialchars($erro) ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label for="email">Email</label>
                <input type="email" id="email" name="email" value="<?= htmlspecialchars($email) ?>" required autofocus>
            </div>

            <div class="form-group">
                <label for="senha">Senha</label>
                <input type="password" id="senha" name="senha" required>
            </div>

            <button type="submit">Entrar</button>
        </form>

        <div class="footer">
            <!-- AQUI ESTÁ O ÍCONE DE FOGUETE INSERIDO COMO EMOJI -->
            <p>&copy; 2025 GABINETE Universo Base 🚀 - Todos os direitos reservados</p>
        </div>
    </div>
</body>

</html>