<?php
// Proteção da sessão
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['user_id'])) {
    header("Location: /gabinete/login.php");
    exit;
}

// Incluir configurações e modelo
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../models/Eleitor.php';

// Verificar se o ID foi fornecido
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<div class='alert alert-danger'>ID do eleitor não fornecido!</div>";
    exit;
}

$id = $_GET['id'];

// Buscar o eleitor usando o Model
try {
    $eleitorModel = new Eleitor();
    $eleitor = $eleitorModel->findById($id);

    if (!$eleitor) {
        echo "<div class='alert alert-danger'>Eleitor não encontrado!</div>";
        exit;
    }
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Erro ao buscar eleitor: " . $e->getMessage() . "</div>";
    exit;
}
?>

<div class="content-box">
    <h1>Detalhes do Eleitor</h1>

    <div class="eleitor-details">
        <div class="detail-header">
            <h2><?= htmlspecialchars($eleitor['nome_completo']) ?></h2>
            <div class="actions">
                <a href="editar.php?id=<?= $eleitor['id'] ?>"
                    style="background-color: #28a745; color: white; padding: 8px 15px; border-radius: 4px; text-decoration: none; margin-right: 10px; display: inline-block;">
                    <i class="bi bi-pencil"></i> Editar
                </a>
                <a href="lista.php"
                    style="background-color: #6c757d; color: white; padding: 8px 15px; border-radius: 4px; text-decoration: none; display: inline-block;">
                    <i class="bi bi-arrow-left"></i> Voltar
                </a>
            </div>
        </div>

        <div class="detail-grid">
            <div class="detail-section">
                <h3>Informações Pessoais</h3>
                <div class="detail-item">
                    <label>Nome Completo:</label>
                    <span><?= htmlspecialchars($eleitor['nome_completo']) ?></span>
                </div>

                <div class="detail-item">
                    <label>CPF:</label>
                    <span><?= !empty($eleitor['cpf']) ? htmlspecialchars($eleitor['cpf']) : 'Não informado' ?></span>
                </div>

                <div class="detail-item">
                    <label>Data de Nascimento:</label>
                    <span><?= $eleitor['data_nascimento'] ? date('d/m/Y', strtotime($eleitor['data_nascimento'])) : 'Não informado' ?></span>
                </div>

                <div class="detail-item">
                    <label>Sexo:</label>
                    <span><?= htmlspecialchars($eleitor['sexo'] ?? 'Não informado') ?></span>
                </div>

                <div class="detail-item">
                    <label>Tipo:</label>
                    <span class="tipo-badge tipo-<?= strtolower($eleitor['tipo']) ?>">
                        <?= htmlspecialchars($eleitor['tipo']) ?>
                    </span>
                </div>
            </div>

            <div class="detail-section">
                <h3>Contato</h3>
                <div class="detail-item">
                    <label>Telefone:</label>
                    <span><?= htmlspecialchars($eleitor['telefone'] ?? 'Não informado') ?></span>
                </div>

                <div class="detail-item">
                    <label>Email:</label>
                    <span><?= htmlspecialchars($eleitor['email'] ?? 'Não informado') ?></span>
                </div>
            </div>

            <div class="detail-section">
                <h3>Endereço</h3>
                <div class="detail-item">
                    <label>Endereço:</label>
                    <span><?= htmlspecialchars($eleitor['endereco'] ?? 'Não informado') ?></span>
                </div>

                <div class="detail-item">
                    <label>Bairro:</label>
                    <span><?= htmlspecialchars($eleitor['bairro'] ?? 'Não informado') ?></span>
                </div>

                <div class="detail-item">
                    <label>CEP:</label>
                    <span><?= htmlspecialchars($eleitor['cep'] ?? 'Não informado') ?></span>
                </div>
            </div>

            <?php if (!empty($eleitor['demanda'])): ?>
                <div class="detail-section full-width" style="border-left-color: #dc3545;">
                    <h3 style="color: #dc3545;">Demanda Inicial</h3>
                    <div class="detail-item">
                        <p><?= nl2br(htmlspecialchars($eleitor['demanda'])) ?></p>
                    </div>
                </div>
            <?php endif; ?>

            <?php if (!empty($eleitor['observacao'])): ?>
                <div class="detail-section full-width">
                    <h3>Observações</h3>
                    <div class="detail-item">
                        <p><?= nl2br(htmlspecialchars($eleitor['observacao'])) ?></p>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
    .eleitor-details {
        background: white;
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
    }

    .detail-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 30px;
        padding-bottom: 20px;
        border-bottom: 2px solid #f0f0f0;
    }

    .detail-header h2 {
        margin: 0;
        color: #333;
        font-size: 24px;
    }

    .actions {
        display: flex;
        gap: 10px;
    }

    .detail-grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
        gap: 30px;
    }

    .detail-section {
        background: #f9f9f9;
        padding: 20px;
        border-radius: 6px;
        border-left: 4px solid #007bff;
    }

    .detail-section.full-width {
        grid-column: 1 / -1;
    }

    .detail-section h3 {
        margin: 0 0 15px 0;
        color: #007bff;
        font-size: 18px;
        font-weight: 600;
    }

    .detail-item {
        margin-bottom: 15px;
    }

    .detail-item:last-child {
        margin-bottom: 0;
    }

    .detail-item label {
        display: block;
        font-weight: 600;
        color: #555;
        margin-bottom: 5px;
        font-size: 14px;
    }

    .detail-item span {
        display: block;
        color: #333;
        font-size: 16px;
    }

    .tipo-badge {
        display: inline-block;
        padding: 4px 12px;
        border-radius: 20px;
        font-size: 12px;
        font-weight: 600;
        text-transform: uppercase;
    }

    .tipo-apoiador {
        background-color: #e3f2fd;
        color: #1976d2;
    }

    .tipo-liderança {
        background-color: #fff3e0;
        color: #f57c00;
    }

    .btn-edit {
        background-color: #28a745;
        color: white;
    }

    .btn-edit:hover {
        background-color: #218838;
    }

    .btn-back {
        background-color: #6c757d;
        color: white;
    }

    .btn-back:hover {
        background-color: #5a6268;
    }
</style>