<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatório de Recursos Humanos - Sistema de Gabinete</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body { background-color: #f4f7f9; font-family: 'Plus Jakarta Sans', sans-serif; color: #5a6a85; }
        .header-section { background-color: #ffffff; padding: 1.5rem 0; margin-bottom: 2.5rem; border-bottom: 1px solid #dee2e6; }
        .page-title { font-size: 1.75rem; font-weight: 800; color: #1e293b; }
        .page-subtitle { font-size: 0.95rem; color: #64748b; }
        .stat-card { background-color: #ffffff; border-radius: 16px; padding: 1.75rem; border: 1px solid #e2e8f0; transition: transform 0.2s ease, box-shadow 0.2s ease; height: 100%; margin-bottom: 1.5rem; }
        .stat-card:hover { transform: translateY(-4px); box-shadow: 0 10px 20px -5px rgba(0, 0, 0, 0.07); }
        .stat-icon { width: 50px; height: 50px; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 1.25rem; margin-bottom: 1rem; }
        .icon-users { background-color: #e0f2fe; color: #0ea5e9; }
        .icon-status { background-color: #e0e7ff; color: #6366f1; }
        .icon-job { background-color: #dcfce7; color: #22c55e; }
        .icon-time { background-color: #ffedd5; color: #f97316; }
        .stat-content .stat-label { font-size: 0.9rem; font-weight: 500; color: #64748b; margin-bottom: 0.25rem; }
        .stat-content .stat-number { font-size: 2.25rem; font-weight: 800; color: #1e293b; line-height: 1; }
        .card-container { background-color: #ffffff; border-radius: 16px; padding: 2rem; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05), 0 2px 4px -2px rgba(0, 0, 0, 0.05); margin-bottom: 2rem; border: 1px solid #e2e8f0; }
        .card-title { font-size: 1.25rem; font-weight: 700; color: #334155; margin-bottom: 1.5rem; }
        .employee-item { border-bottom: 1px solid #e2e8f0; padding: 1rem 0; transition: background-color 0.2s ease; }
        .employee-item:last-child { border-bottom: none; }
        .employee-item:hover { background-color: #f8fafc; border-radius: 8px; margin: 0 -1rem; padding: 1rem; }
        .btn-back { background-color: #f1f5f9; color: #475569; border: 1px solid #e2e8f0; border-radius: 8px; padding: 0.5rem 1rem; text-decoration: none; transition: all 0.2s ease; }
        .btn-back:hover { background-color: #e2e8f0; color: #334155; }
        .btn-print { background-color: #0ea5e9; color: white; border: none; border-radius: 8px; padding: 0.5rem 1rem; transition: all 0.2s ease; }
        .btn-print:hover { background-color: #0284c7; color: white; }
        @media print { .no-print { display: none !important; } body { background-color: white !important; } }
    </style>
</head>
<body>
    <div class="header-section no-print">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-8">
                    <h1 class="page-title mb-0"><i class="fas fa-users me-3"></i>Relatório de Recursos Humanos</h1>
                    <p class="page-subtitle mb-0 mt-2">Dados atualizados em <?= date('d/m/Y H:i') ?></p>
                </div>
                <div class="col-md-4 text-end">
                    <a href="<?= @$BASE_URL ?>/employees" class="btn-back me-2">
                        <i class="fas fa-arrow-left me-2"></i>Voltar para RH
                    </a>
                    <button class="btn-print no-print" onclick="window.print()">
                        <i class="fas fa-print me-2"></i>Imprimir Relatório
                    </button>
                </div>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="row mb-4">
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="d-flex align-items-start">
                        <div class="stat-icon icon-users"><i class="fas fa-users"></i></div>
                        <div class="stat-content ms-3">
                            <div class="stat-label">Total de Colaboradores</div>
                            <div class="stat-number"><?= @$dados['totalColaboradores'] ?? 0 ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="d-flex align-items-start">
                        <div class="stat-icon icon-status"><i class="fas fa-check-circle"></i></div>
                        <div class="stat-content ms-3">
                            <div class="stat-label">Status Diferentes</div>
                            <div class="stat-number"><?= isset($dados['porStatus']) ? count($dados['porStatus']) : 0 ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="d-flex align-items-start">
                        <div class="stat-icon icon-job"><i class="fas fa-briefcase"></i></div>
                        <div class="stat-content ms-3">
                            <div class="stat-label">Cargos Diferentes</div>
                            <div class="stat-number"><?= isset($dados['porCargo']) ? count($dados['porCargo']) : 0 ?></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-md-6">
                <div class="stat-card">
                    <div class="d-flex align-items-start">
                        <div class="stat-icon icon-time"><i class="fas fa-clock"></i></div>
                        <div class="stat-content ms-3">
                            <div class="stat-label">Registros de Ponto</div>
                            <div class="stat-number"><?= @$dados['estatisticasPonto']['total_registros'] ?? 0 ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <?php if (!empty($dados['porStatus'])): ?>
            <div class="col-md-6">
                <div class="card-container">
                    <h5 class="card-title"><i class="fas fa-check-circle me-2"></i>Distribuição por Status</h5>
                    <div style="height: 350px;"><canvas id="statusChart"></canvas></div>
                </div>
            </div>
            <?php endif; ?>
            
            <?php if (!empty($dados['porCargo'])): ?>
            <div class="col-md-6">
                <div class="card-container">
                    <h5 class="card-title"><i class="fas fa-briefcase me-2"></i>Colaboradores por Cargo</h5>
                    <div style="height: 350px;"><canvas id="cargoChart"></canvas></div>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <?php if (!empty($dados['porContrato'])): ?>
        <div class="row mb-4">
            <div class="col-md-12">
                <div class="card-container">
                    <h5 class="card-title"><i class="fas fa-file-signature me-2"></i>Tipos de Contrato</h5>
                    <div style="height: 300px;"><canvas id="contratoChart"></canvas></div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php if (!empty($dados['colaboradoresRecentes'])): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="card-container">
                    <h5 class="card-title"><i class="fas fa-user-plus me-2"></i>Colaboradores Recentes</h5>
                    <?php foreach ($dados['colaboradoresRecentes'] as $colaborador): ?>
                    <div class="employee-item">
                        <div class="row align-items-center">
                            <div class="col-md-4">
                                <strong><?= htmlspecialchars($colaborador['full_name'] ?? 'Nome não informado') ?></strong>
                            </div>
                            <div class="col-md-3">
                                <span class="text-muted"><?= htmlspecialchars($colaborador['job_title'] ?? 'Cargo não informado') ?></span>
                            </div>
                            <div class="col-md-3">
                                <span class="badge bg-primary rounded-pill"><?= htmlspecialchars($colaborador['status'] ?? 'ativo') ?></span>
                            </div>
                            <div class="col-md-2 text-end">
                                <small class="text-muted">
                                    <i class="fas fa-calendar-alt me-1"></i>
                                    <?= date('d/m/Y', strtotime($colaborador['hire_date'] ?? '1970-01-01')) ?>
                                </small>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <script>
        // =================================================================
        // AJUSTES DOS GRÁFICOS
        // =================================================================

        // Paleta de cores profissional e consistente
        const CHART_COLORS = ['#3b82f6', '#16a34a', '#f97316', '#9333ea', '#db2777', '#f59e0b', '#14b8a6', '#64748b'];

        // Configurações globais para todos os gráficos
        Chart.defaults.font.family = "'Plus Jakarta Sans', sans-serif";
        Chart.defaults.responsive = true;
        Chart.defaults.maintainAspectRatio = false;
        Chart.defaults.plugins.legend.position = 'bottom';
        Chart.defaults.plugins.tooltip.backgroundColor = '#1e293b';
        Chart.defaults.plugins.tooltip.titleFont.size = 14;
        Chart.defaults.plugins.tooltip.bodyFont.size = 12;
        Chart.defaults.plugins.tooltip.padding = 10;
        Chart.defaults.plugins.tooltip.cornerRadius = 8;
        
    <?php if (!empty($dados['porStatus'])): ?>
        // Gráfico de Status (agora Doughnut)
        new Chart(document.getElementById('statusChart'), {
            type: 'doughnut',
            data: {
                labels: <?= json_encode(array_keys($dados['porStatus'])) ?>,
                datasets: [{
                    data: <?= json_encode(array_values($dados['porStatus'])) ?>,
                    backgroundColor: CHART_COLORS,
                    borderColor: '#ffffff',
                    borderWidth: 4,
                    hoverOffset: 15
                }]
            },
            options: { cutout: '70%' }
        });
    <?php endif; ?>

    <?php if (!empty($dados['porCargo'])): ?>
        // Gráfico de Cargos (agora Horizontal)
        new Chart(document.getElementById('cargoChart'), {
            type: 'bar',
            data: {
                labels: <?= json_encode(array_keys($dados['porCargo'])) ?>,
                datasets: [{
                    label: 'Colaboradores',
                    data: <?= json_encode(array_values($dados['porCargo'])) ?>,
                    backgroundColor: CHART_COLORS,
                    borderColor: CHART_COLORS,
                    borderWidth: 1,
                    borderRadius: 6
                }]
            },
            options: {
                indexAxis: 'y', // <-- EIXO HORIZONTAL
                scales: {
                    x: { beginAtZero: true, ticks: { precision: 0 } }
                },
                plugins: {
                    legend: { display: false }
                }
            }
        });
    <?php endif; ?>

    <?php if (!empty($dados['porContrato'])): ?>
        // Gráfico de Contratos
        new Chart(document.getElementById('contratoChart'), {
            type: 'doughnut',
            data: {
                labels: <?= json_encode(array_keys($dados['porContrato'])) ?>,
                datasets: [{
                    data: <?= json_encode(array_values($dados['porContrato'])) ?>,
                    backgroundColor: CHART_COLORS.slice().reverse(), // Inverte as cores para variar
                    borderColor: '#ffffff',
                    borderWidth: 4,
                    hoverOffset: 15
                }]
            },
            options: { cutout: '60%' }
        });
    <?php endif; ?>
    </script>

    <footer class="mt-5 py-4 no-print" style="background-color: #1e293b; color: white;">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h5 class="mb-3"><i class="fas fa-building me-2"></i>Sistema de Gabinete</h5>
                    <p class="mb-2" style="color: #cbd5e1;">Plataforma completa para gestão de recursos humanos e administração pública.</p>
                    <p class="mb-0" style="color: #94a3b8; font-size: 0.875rem;">Desenvolvido para otimizar processos e facilitar o controle administrativo.</p>
                </div>
                <div class="col-md-3">
                    <h6 class="mb-3">Módulos</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="<?= @$BASE_URL ?>/employees" class="text-decoration-none" style="color: #cbd5e1;"><i class="fas fa-users me-2"></i>Colaboradores</a></li>
                        <li class="mb-2"><a href="<?= @$BASE_URL ?>/payrolls" class="text-decoration-none" style="color: #cbd5e1;"><i class="fas fa-money-check-alt me-2"></i>Folha de Pagamento</a></li>
                        <li class="mb-2"><a href="<?= @$BASE_URL ?>/time-records" class="text-decoration-none" style="color: #cbd5e1;"><i class="fas fa-clock me-2"></i>Controle de Ponto</a></li>
                    </ul>
                </div>
                <div class="col-md-3">
                    <h6 class="mb-3">Informações</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2"><i class="fas fa-calendar-alt me-2"></i><span style="color: #cbd5e1;">Data: <?= date('d/m/Y') ?></span></li>
                        <li class="mb-2"><i class="fas fa-clock me-2"></i><span style="color: #cbd5e1;">Hora: <?= date('H:i') ?></span></li>
                        <li class="mb-2"><i class="fas fa-chart-line me-2"></i><span style="color: #cbd5e1;">Relatório Atualizado</span></li>
                    </ul>
                </div>
            </div>
            <hr style="border-color: #475569; margin: 1.5rem 0;">
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-0" style="color: #94a3b8; font-size: 0.875rem;">© <?= date('Y') ?> Sistema de Gabinete. Todos os direitos reservados.</p>
                </div>
                <div class="col-md-6 text-end">
                    <p class="mb-0" style="color: #94a3b8; font-size: 0.875rem;">Versão 1.0 | <a href="#" class="text-decoration-none" style="color: #cbd5e1;">Suporte Técnico</a></p>
                </div>
            </div>
        </div>
    </footer>
</body>
</html>