<?php
require 'db.php';

// ===== 1. LÓGICA PARA PROCESSAR O FILTRO DE DATA =====
$ano_selecionado = isset($_GET['ano']) ? (int)$_GET['ano'] : date('Y');
// CORREÇÃO APLICADA AQUI: Convertendo o resultado de date('m') para inteiro
$mes_selecionado = isset($_GET['mes']) ? (int)$_GET['mes'] : (int)date('m'); 
$params = [];
$tipos_params = '';
if ($mes_selecionado != 0) {
    $filtro_sql = "WHERE YEAR(data_transacao) = ? AND MONTH(data_transacao) = ?";
    $params = [$ano_selecionado, $mes_selecionado];
    $tipos_params = 'ii';
} else {
    $filtro_sql = "WHERE YEAR(data_transacao) = ?";
    $params = [$ano_selecionado];
    $tipos_params = 'i';
}

// ===== 2. LÓGICA PARA PROCESSAR AÇÕES =====
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['acao'])) {
        switch ($_POST['acao']) {
            case 'adicionar_transacao':
                $tipo_e_origem = explode(':', $_POST['tipo_origem']);
                $tipo = $tipo_e_origem[0];
                $origem = $tipo_e_origem[1];
                $data_transacao = $_POST['data_transacao'];
                $descricao = trim($_POST['descricao']);
                $valor_str = str_replace(',', '.', $_POST['valor']);
                $valor = (float)$valor_str;
                $forma_pagamento = !empty($_POST['forma_pagamento']) ? trim($_POST['forma_pagamento']) : null;
                $entidade = !empty($_POST['entidade']) ? trim($_POST['entidade']) : null;
                
                // Lógica para comissão
                $comissao_para = null;
                if (!empty($_POST['comissao_para'])) {
                    $comissao_para = trim($_POST['comissao_para']);
                } elseif (!empty($_POST['comissao_para_custom'])) {
                    $comissao_para = trim($_POST['comissao_para_custom']);
                }
                
                // Para comissões, usar o campo comissao_para como entidade
                if ($origem == 'COMISSOES' && !empty($comissao_para)) {
                    $entidade = $comissao_para;
                }
                
                // Upload do comprovante
                $comprovante_nome = null;
                if (isset($_FILES['comprovante_pagamento']) && $_FILES['comprovante_pagamento']['error'] == UPLOAD_ERR_OK) {
                    $comprovante_nome = fazer_upload_arquivo($_FILES['comprovante_pagamento']);
                }

                if (!empty($data_transacao) && !empty($tipo) && !empty($origem) && !empty($descricao) && $valor > 0) {
                    $sql_insert = "INSERT INTO transacoes (data_transacao, tipo, descricao, valor, forma_pagamento, comprovante_pagamento, entidade, origem) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
                    $stmt_insert = $conexao->prepare($sql_insert);
                    $stmt_insert->bind_param('sssdssss', $data_transacao, $tipo, $descricao, $valor, $forma_pagamento, $comprovante_nome, $entidade, $origem);
                    if ($stmt_insert->execute()) {
                        header("Location: index.php?status=success&ano=$ano_selecionado&mes=$mes_selecionado");
                        exit();
                    } else {
                        header("Location: index.php?status=error&ano=$ano_selecionado&mes=$mes_selecionado");
                        exit();
                    }
                } else {
                    header("Location: index.php?status=validation_error&ano=$ano_selecionado&mes=$mes_selecionado");
                    exit();
                }
                break;
                
            case 'excluir_transacao':
                $id = (int)$_POST['id'];
                if ($id > 0) {
                    // Buscar o comprovante para deletar o arquivo
                    $stmt_buscar = $conexao->prepare("SELECT comprovante_pagamento FROM transacoes WHERE id = ?");
                    $stmt_buscar->bind_param('i', $id);
                    $stmt_buscar->execute();
                    $resultado = $stmt_buscar->get_result();
                    if ($transacao = $resultado->fetch_assoc()) {
                        // Deletar arquivo do comprovante se existir
                        if (!empty($transacao['comprovante_pagamento']) && file_exists('uploads/comprovantes/' . $transacao['comprovante_pagamento'])) {
                            unlink('uploads/comprovantes/' . $transacao['comprovante_pagamento']);
                        }
                    }
                    
                    // Deletar a transação
                    $stmt_delete = $conexao->prepare("DELETE FROM transacoes WHERE id = ?");
                    $stmt_delete->bind_param('i', $id);
                    if ($stmt_delete->execute()) {
                        header("Location: index.php?status=deleted&ano=$ano_selecionado&mes=$mes_selecionado");
                        exit();
                    }
                }
                header("Location: index.php?status=error&ano=$ano_selecionado&mes=$mes_selecionado");
                exit();
                break;
                
            case 'limpar_todas_transacoes':
                if (isset($_POST['confirmar_limpeza']) && $_POST['confirmar_limpeza'] == 'SIM') {
                    // Deletar todos os arquivos de comprovantes
                    $comprovantes = $conexao->query("SELECT comprovante_pagamento FROM transacoes WHERE comprovante_pagamento IS NOT NULL");
                    while ($comp = $comprovantes->fetch_assoc()) {
                        if (file_exists('uploads/comprovantes/' . $comp['comprovante_pagamento'])) {
                            unlink('uploads/comprovantes/' . $comp['comprovante_pagamento']);
                        }
                    }
                    
                    // Limpar todas as transações
                    $conexao->query("TRUNCATE TABLE transacoes");
                    header("Location: index.php?status=all_deleted&ano=$ano_selecionado&mes=$mes_selecionado");
                    exit();
                }
                header("Location: index.php?status=error&ano=$ano_selecionado&mes=$mes_selecionado");
                exit();
                break;
        }
    }
}

// ===== 3. LÓGICA PARA BUSCAR DADOS PARA O DASHBOARD =====
function executar_query_com_filtro($conexao, $sql, $params, $tipos_params) {
    $stmt = $conexao->prepare($sql);
    if (!empty($params)) {
        $stmt->bind_param($tipos_params, ...$params);
    }
    $stmt->execute();
    return $stmt->get_result();
}

$sql_receitas = "SELECT SUM(valor) as total FROM transacoes " . $filtro_sql . " AND tipo = 'Receita'";
$receitas_query = executar_query_com_filtro($conexao, $sql_receitas, $params, $tipos_params);
$total_receitas = $receitas_query->fetch_assoc()['total'] ?? 0;

$sql_despesas = "SELECT SUM(valor) as total FROM transacoes " . $filtro_sql . " AND tipo = 'Despesa'";
$despesas_query = executar_query_com_filtro($conexao, $sql_despesas, $params, $tipos_params);
$total_despesas = $despesas_query->fetch_assoc()['total'] ?? 0;

$saldo_total = $total_receitas - $total_despesas;

$sql_transacoes = "SELECT * FROM transacoes " . $filtro_sql . " ORDER BY data_transacao DESC, id DESC";
$transacoes = executar_query_com_filtro($conexao, $sql_transacoes, $params, $tipos_params);

$nomes_meses = [1=>'Janeiro', 2=>'Fevereiro', 3=>'Março', 4=>'Abril', 5=>'Maio', 6=>'Junho', 7=>'Julho', 8=>'Agosto', 9=>'Setembro', 10=>'Outubro', 11=>'Novembro', 12=>'Dezembro'];
$titulo_relatorio = ($mes_selecionado == 0) ? "$ano_selecionado" : $nomes_meses[$mes_selecionado] . " de $ano_selecionado";
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Financeiro Imobiliária</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #333; min-height: 100vh; }
        
        .header { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); box-shadow: 0 4px 20px rgba(0,0,0,0.1); padding: 20px 0; margin-bottom: 30px; }
        .header-content { max-width: 1200px; margin: 0 auto; display: flex; align-items: center; justify-content: space-between; padding: 0 25px; }
        .logo-section { display: flex; align-items: center; gap: 20px; }
        .logo-section img { height: 60px; width: auto; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .title-section h1 { font-size: 28px; font-weight: 700; color: #2c3e50; margin-bottom: 5px; }
        .title-section p { font-size: 14px; color: #7f8c8d; font-weight: 500; }
        
        .container { max-width: 1200px; margin: auto; background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); padding: 30px; border-radius: 16px; box-shadow: 0 8px 32px rgba(0,0,0,0.1); }
        
        .navigation { display: flex; justify-content: center; gap: 15px; margin-bottom: 30px; padding: 15px; background: rgba(52, 73, 94, 0.05); border-radius: 12px; }
        .nav-link { padding: 12px 24px; background: linear-gradient(135deg, #3498db, #2980b9); color: white; text-decoration: none; border-radius: 8px; transition: all 0.3s ease; font-weight: 500; box-shadow: 0 2px 8px rgba(52, 152, 219, 0.3); }
        .nav-link:hover { transform: translateY(-2px); box-shadow: 0 4px 16px rgba(52, 152, 219, 0.4); }
        .nav-link.active { background: linear-gradient(135deg, #2c3e50, #34495e); box-shadow: 0 4px 16px rgba(44, 62, 80, 0.4); }
        
        .summary { display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 20px; margin: 30px 0; }
        .summary-box { background: linear-gradient(135deg, #f8f9fa, #e9ecef); padding: 25px; border-radius: 12px; text-align: center; box-shadow: 0 4px 16px rgba(0,0,0,0.05); border: 1px solid rgba(255,255,255,0.2); }
        .summary-box h3 { font-size: 14px; color: #7f8c8d; text-transform: uppercase; margin-bottom: 10px; font-weight: 600; letter-spacing: 1px; }
        .summary-box p { font-size: 32px; font-weight: 700; margin: 0; }
        .receita { color: #27ae60; }
        .despesa { color: #e74c3c; }
        .saldo { color: #3498db; }
        
        .form-container, .filter-container { background: linear-gradient(135deg, #f8f9fa, #e9ecef); padding: 25px; border-radius: 12px; margin-bottom: 25px; box-shadow: 0 4px 16px rgba(0,0,0,0.05); }
        .form-container h2, .filter-container h2 { color: #2c3e50; margin-bottom: 20px; font-weight: 600; text-align: center; }
        
        .form-row { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 20px; margin-bottom: 20px; align-items: end; }
        .form-group { display: flex; flex-direction: column; }
        .form-group label { margin-bottom: 8px; font-weight: 600; color: #2c3e50; font-size: 14px; }
        .form-group input, .form-group select { padding: 12px; border: 2px solid #e9ecef; border-radius: 8px; font-size: 14px; transition: all 0.3s ease; background: white; }
        .form-group input:focus, .form-group select:focus { outline: none; border-color: #3498db; box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1); }
        .form-group button { padding: 14px; background: linear-gradient(135deg, #27ae60, #2ecc71); color: white; border: none; border-radius: 8px; font-size: 16px; font-weight: 600; cursor: pointer; transition: all 0.3s ease; box-shadow: 0 4px 16px rgba(39, 174, 96, 0.3); }
        .form-group button:hover { transform: translateY(-2px); box-shadow: 0 6px 20px rgba(39, 174, 96, 0.4); }
        
        .btn-small { padding: 6px 12px; font-size: 11px; margin: 2px; border: none; border-radius: 4px; cursor: pointer; font-weight: 600; transition: all 0.3s ease; }
        .btn-danger { background: linear-gradient(135deg, #e74c3c, #c0392b); color: white; }
        .btn-warning { background: linear-gradient(135deg, #f39c12, #e67e22); color: white; }
        .btn-small:hover { transform: translateY(-1px); }
        
        .danger-zone { background: linear-gradient(135deg, #fff5f5, #fed7d7); border: 2px solid #feb2b2; padding: 20px; border-radius: 12px; margin: 20px 0; }
        .danger-zone h3 { color: #c53030; margin-bottom: 15px; }
        .danger-zone p { color: #742a2a; margin-bottom: 15px; }
        
        table { width: 100%; border-collapse: collapse; margin-top: 20px; background: white; border-radius: 12px; overflow: hidden; box-shadow: 0 4px 16px rgba(0,0,0,0.05); }
        th, td { padding: 16px; text-align: left; border-bottom: 1px solid #e9ecef; }
        th { background: linear-gradient(135deg, #34495e, #2c3e50); color: white; font-weight: 600; text-transform: uppercase; font-size: 12px; letter-spacing: 1px; }
        td.valor { font-weight: 700; text-align: right; }
        tr:hover { background-color: rgba(52, 152, 219, 0.05); }
        
        .alert { padding: 16px; margin-bottom: 20px; border-radius: 8px; text-align: center; font-weight: 600; }
        .alert-success { background: linear-gradient(135deg, #d4edda, #c3e6cb); color: #155724; border: 1px solid #c3e6cb; }
        .alert-error { background: linear-gradient(135deg, #f8d7da, #f5c6cb); color: #721c24; border: 1px solid #f5c6cb; }
        .alert-warning { background: linear-gradient(135deg, #fff3cd, #ffeaa7); color: #856404; border: 1px solid #ffeaa7; }
        
        .comprovante-link { color: #3498db; text-decoration: none; font-weight: 600; }
        .comprovante-link:hover { text-decoration: underline; }
        
        .modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; background-color: rgba(0,0,0,0.5); }
        .modal-content { background-color: white; margin: 15% auto; padding: 30px; border-radius: 12px; width: 90%; max-width: 500px; box-shadow: 0 8px 32px rgba(0,0,0,0.3); }
        .modal h3 { color: #c53030; margin-bottom: 20px; }
        .modal-buttons { display: flex; gap: 10px; margin-top: 20px; }
        .modal-buttons button { flex: 1; padding: 12px; border: none; border-radius: 8px; font-weight: 600; cursor: pointer; }
        
        @media (max-width: 768px) {
            .header-content { flex-direction: column; gap: 15px; text-align: center; }
            .navigation { flex-direction: column; align-items: center; }
            .form-row { grid-template-columns: 1fr; }
            .summary { grid-template-columns: 1fr; }
            .container { margin: 20px; padding: 20px; }
        }
    </style>
</head>
<body>

<div class="header">
    <div class="header-content">
        <div class="logo-section">
            <img src="/publico_html/assets/img/logo.png" alt="Logo Imobiliária">
            <div class="title-section">
                <h1>Financeiro Imobiliária</h1>
                <p>Sistema de Gestão Financeira</p>
            </div>
        </div>
    </div>
</div>

<div class="container">
    
    <div class="navigation">
        <a href="index.php" class="nav-link active">Dashboard</a>
        <a href="contas.php" class="nav-link">Controle de Contas</a>
        <a href="relatorios.php" class="nav-link">Relatórios</a>
    </div>

    <?php
    if (isset($_GET['status'])) {
        if ($_GET['status'] == 'success') echo '<div class="alert alert-success">Transação adicionada com sucesso!</div>';
        elseif ($_GET['status'] == 'deleted') echo '<div class="alert alert-warning">Transação excluída com sucesso!</div>';
        elseif ($_GET['status'] == 'all_deleted') echo '<div class="alert alert-warning">Todas as transações foram excluídas!</div>';
        elseif ($_GET['status'] == 'error') echo '<div class="alert alert-error">Erro ao processar solicitação. Tente novamente.</div>';
        elseif ($_GET['status'] == 'validation_error') echo '<div class="alert alert-error">Preencha todos os campos obrigatórios.</div>';
    }
    ?>

    <div class="filter-container">
        <h2>Selecionar Período</h2>
        <form action="index.php" method="GET">
            <div class="form-row">
                <div class="form-group">
                    <label for="mes">Mês</label>
                    <select name="mes" id="mes">
                        <option value="0" <?= ($mes_selecionado == 0) ? 'selected' : '' ?>>Todos os Meses (Anual)</option>
                        <?php foreach ($nomes_meses as $num => $nome): ?>
                            <option value="<?= $num ?>" <?= ($mes_selecionado == $num) ? 'selected' : '' ?>><?= $nome ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="ano">Ano</label>
                    <select name="ano" id="ano">
                        <?php for ($ano = date('Y'); $ano >= date('Y') - 5; $ano--): ?>
                            <option value="<?= $ano ?>" <?= ($ano_selecionado == $ano) ? 'selected' : '' ?>><?= $ano ?></option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="form-group">
                    <button type="submit">Filtrar</button>
                </div>
            </div>
        </form>
    </div>

    <div class="form-container">
        <h2>Novo Lançamento</h2>
        <form action="index.php?ano=<?= $ano_selecionado ?>&mes=<?= $mes_selecionado ?>" method="post" enctype="multipart/form-data">
            <input type="hidden" name="acao" value="adicionar_transacao">
            <div class="form-row">
                <div class="form-group">
                    <label for="data_transacao">Data*</label>
                    <input type="date" id="data_transacao" name="data_transacao" value="<?= date('Y-m-d') ?>" required>
                </div>
                <div class="form-group">
                    <label for="tipo_origem">Tipo de Lançamento*</label>
                    <select id="tipo_origem" name="tipo_origem" required>
                        <option value="Despesa:DESPESAS_AURY_DONATO">Despesas Aury Donato</option>
                        <option value="Despesa:DESPESAS_IMOBILIARIA">Despesas Imobiliária</option>
                        <option value="Receita:RECEITA_IMOBILIARIA">Receita Imobiliária</option>
                        <option value="Despesa:COMISSOES">Comissões (Saída de Capital)</option>
                    </select>
                </div>
                <div class="form-group" style="grid-column: span 2;">
                    <label for="descricao">Descrição*</label>
                    <input type="text" id="descricao" name="descricao" required>
                </div>
                <div class="form-group">
                    <label for="valor">Valor (R$)*</label>
                    <input type="text" id="valor" name="valor" placeholder="150,50" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group" id="group-entidade" style="display:none;">
                    <label for="entidade">Cliente / Fonte Pagadora</label>
                    <input type="text" id="entidade" name="entidade">
                </div>
                <div class="form-group" id="group-comissao" style="display:none;">
                    <label for="comissao_para">Comissão Para*</label>
                    <select id="comissao_para" name="comissao_para" onchange="toggleComissaoInput()">
                        <option value="">Selecione ou digite...</option>
                        <option value="Rafaela">Rafaela</option>
                        <option value="Moises">Moises</option>
                        <option value="Clair">Clair</option>
                        <option value="Lene">Lene</option>
                        <option value="outro">Outro (digitar)</option>
                    </select>
                    <input type="text" id="comissao_para_custom" name="comissao_para_custom" placeholder="Digite o nome..." style="display:none; margin-top:10px; padding:12px; border:2px solid #e9ecef; border-radius:8px; font-size:14px; background:white;">
                </div>
                <div class="form-group">
                    <label for="forma_pagamento">Forma de Pagamento</label>
                    <input type="text" id="forma_pagamento" name="forma_pagamento" placeholder="PIX, Cartão, Dinheiro, etc.">
                </div>
                <div class="form-group">
                    <label for="comprovante_pagamento">Comprovante de Pagamento</label>
                    <input type="file" id="comprovante_pagamento" name="comprovante_pagamento" accept=".jpg,.jpeg,.png,.pdf,.doc,.docx">
                    <small style="color: #666; font-size: 12px;">Formatos aceitos: JPG, PNG, PDF, DOC, DOCX</small>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <button type="submit">Adicionar Transação</button>
                </div>
            </div>
        </form>
    </div>

    <div class="report-content">
        <h2><?= $titulo_relatorio ?></h2>
        <div class="summary">
            <div class="summary-box">
                <h3>Total de Receitas</h3>
                <p class="receita">R$ <?= number_format($total_receitas, 2, ',', '.') ?></p>
            </div>
            <div class="summary-box">
                <h3>Total de Despesas</h3>
                <p class="despesa">R$ <?= number_format($total_despesas, 2, ',', '.') ?></p>
            </div>
            <div class="summary-box">
                <h3>Saldo Final</h3>
                <p class="saldo">R$ <?= number_format($saldo_total, 2, ',', '.') ?></p>
            </div>
        </div>

    <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
        <div style="width: 120px;"></div> <h3 style="margin: 0; flex-grow: 1; text-align: center;">Histórico de Transações do Período</h3>
        <button onclick="abrirModalLimparTudo()" class="btn-small btn-danger">🗑️ Limpar Todas</button>
    </div>
        
        <table>
            <thead>
                <tr><th>Data</th><th>Origem</th><th>Descrição</th><th>Entidade/Comissão</th><th>Forma Pagto</th><th>Comprovante</th><th style="text-align: right;">Valor</th><th>Ações</th></tr>
            </thead>
            <tbody>
                <?php while ($t = $transacoes->fetch_assoc()): ?>
                    <tr>
                        <td><?= date("d/m/Y", strtotime($t['data_transacao'])) ?></td>
                        <td><?= htmlspecialchars($t['origem']) ?></td>
                        <td><?= htmlspecialchars($t['descricao']) ?></td>
                        <td><?= htmlspecialchars($t['entidade'] ?? '-') ?></td>
                        <td><?= htmlspecialchars($t['forma_pagamento'] ?? '-') ?></td>
                        <td>
                            <?php if ($t['comprovante_pagamento']): ?>
                                <a href="uploads/comprovantes/<?= $t['comprovante_pagamento'] ?>" target="_blank" class="comprovante-link">Ver</a>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td class="valor <?= ($t['tipo'] == 'Receita') ? 'receita' : 'despesa' ?>"><?= (($t['tipo'] == 'Despesa') ? '-' : '+') ?> R$ <?= number_format($t['valor'], 2, ',', '.') ?></td>
                        <td>
                            <button onclick="excluirTransacao(<?= $t['id'] ?>, '<?= htmlspecialchars($t['descricao']) ?>')" class="btn-small btn-danger">🗑️</button>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>

<div id="modalExcluirTransacao" class="modal">
    <div class="modal-content">
        <h3>⚠️ Confirmar Exclusão</h3>
        <p>Tem certeza que deseja excluir esta transação?</p>
        <p><strong id="descricaoTransacao"></strong></p>
        <p style="color: #c53030; font-size: 14px;">Esta ação não pode ser desfeita!</p>
        <form method="post" id="formExcluirTransacao">
            <input type="hidden" name="acao" value="excluir_transacao">
            <input type="hidden" name="id" id="idTransacao">
            <input type="hidden" name="ano" value="<?= $ano_selecionado ?>">
            <input type="hidden" name="mes" value="<?= $mes_selecionado ?>">
            <div class="modal-buttons">
                <button type="button" onclick="fecharModal('modalExcluirTransacao')" style="background: #6c757d; color: white;">Cancelar</button>
                <button type="submit" style="background: #dc3545; color: white;">Excluir</button>
            </div>
        </form>
    </div>
</div>

<div id="modalLimparTudo" class="modal">
    <div class="modal-content">
        <h3>🚨 ATENÇÃO - AÇÃO IRREVERSÍVEL</h3>
        <p><strong>Você está prestes a excluir TODAS as transações!</strong></p>
        <p>Esta ação irá:</p>
        <ul style="margin: 15px 0; padding-left: 20px; color: #c53030;">
            <li>Deletar todas as transações do banco de dados</li>
            <li>Remover todos os comprovantes de pagamento</li>
            <li>Zerar todos os relatórios e estatísticas</li>
        </ul>
        <p style="color: #c53030; font-weight: bold;">ESTA AÇÃO NÃO PODE SER DESFEITA!</p>
        
        <form method="post" id="formLimparTudo">
            <input type="hidden" name="acao" value="limpar_todas_transacoes">
            <input type="hidden" name="ano" value="<?= $ano_selecionado ?>">
            <input type="hidden" name="mes" value="<?= $mes_selecionado ?>">
            
            <div style="margin: 20px 0; padding: 15px; background: #fff3cd; border-radius: 8px;">
                <label style="display: flex; align-items: center; font-weight: bold;">
                    <input type="checkbox" id="confirmarLimpeza" name="confirmar_limpeza" value="SIM" required style="margin-right: 10px;">
                    Eu confirmo que quero excluir TODAS as transações
                </label>
            </div>
            
            <div class="modal-buttons">
                <button type="button" onclick="fecharModal('modalLimparTudo')" style="background: #6c757d; color: white;">Cancelar</button>
                <button type="submit" style="background: #dc3545; color: white;" id="btnConfirmarLimpeza" disabled>Excluir Tudo</button>
            </div>
        </form>
    </div>
</div>

<script>
    function toggleComissaoInput() {
        var select = document.getElementById('comissao_para');
        var customInput = document.getElementById('comissao_para_custom');
        
        if (select.value === 'outro') {
            customInput.style.display = 'block';
            customInput.required = true;
            select.name = '';
            customInput.name = 'comissao_para_custom';
        } else {
            customInput.style.display = 'none';
            customInput.required = false;
            select.name = 'comissao_para';
            customInput.name = '';
        }
    }

    document.getElementById('tipo_origem').addEventListener('change', function () {
        var groupEntidade = document.getElementById('group-entidade');
        var groupComissao = document.getElementById('group-comissao');
        var comissaoSelect = document.getElementById('comissao_para');
        var comissaoCustom = document.getElementById('comissao_para_custom');
        
        // Resetar campos
        groupEntidade.style.display = 'none';
        groupComissao.style.display = 'none';
        comissaoSelect.required = false;
        comissaoCustom.required = false;
        
        if (this.value.includes('RECEITA_IMOBILIARIA')) {
            groupEntidade.style.display = 'block';
        } else if (this.value.includes('COMISSOES')) {
            groupComissao.style.display = 'block';
            comissaoSelect.required = true;
        }
    });
    
    // Executar ao carregar a página
    document.getElementById('tipo_origem').dispatchEvent(new Event('change'));
    
    // Funções para modais
    function excluirTransacao(id, descricao) {
        document.getElementById('idTransacao').value = id;
        document.getElementById('descricaoTransacao').textContent = descricao;
        document.getElementById('modalExcluirTransacao').style.display = 'block';
    }
    
    function abrirModalLimparTudo() {
        document.getElementById('modalLimparTudo').style.display = 'block';
    }
    
    function fecharModal(modalId) {
        document.getElementById(modalId).style.display = 'none';
    }
    
    // Fechar modal clicando fora
    window.onclick = function(event) {
        if (event.target.classList.contains('modal')) {
            event.target.style.display = 'none';
        }
    }
    
    // Habilitar botão de confirmação apenas quando checkbox marcado
    document.getElementById('confirmarLimpeza').addEventListener('change', function() {
        document.getElementById('btnConfirmarLimpeza').disabled = !this.checked;
    });
</script>

</body>
</html>
<?php $conexao->close(); ?>