<?php
// O código PHP para buscar os dados do banco permanece o mesmo.
// Apenas a seção <script> no final do arquivo foi alterada.

require 'db.php';

// Verificar se foi solicitada geração de relatório
if (isset($_GET['gerar'])) {
    $tipo = $_GET['gerar'];
    $ano = isset($_GET['ano']) ? (int)$_GET['ano'] : date('Y');
    $mes = isset($_GET['mes']) ? (int)$_GET['mes'] : 0;
    
    // Filtro de data
    $filtro_sql = $mes == 0 ? "WHERE YEAR(data_transacao) = $ano" : "WHERE YEAR(data_transacao) = $ano AND MONTH(data_transacao) = $mes";
    
    if ($tipo == 'excel') {
        gerarExcel($conexao, $filtro_sql, $ano, $mes);
    } elseif ($tipo == 'pdf') {
        gerarPDF($conexao, $filtro_sql, $ano, $mes);
    }
}

function gerarExcel($conexao, $filtro_sql, $ano, $mes) {
    $nomes_meses = [1=>'Janeiro', 2=>'Fevereiro', 3=>'Março', 4=>'Abril', 5=>'Maio', 6=>'Junho', 7=>'Julho', 8=>'Agosto', 9=>'Setembro', 10=>'Outubro', 11=>'Novembro', 12=>'Dezembro'];
    $periodo = $mes == 0 ? "Anual_$ano" : $nomes_meses[$mes] . "_$ano";
    
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="Relatorio_Financeiro_' . $periodo . '.xls"');
    header('Cache-Control: max-age=0');
    
    echo "<table border='1'>";
    echo "<tr><th colspan='7' style='text-align:center; font-size:16px; font-weight:bold;'>Relatório Financeiro Imobiliária e Aury - $periodo</th></tr>";
    echo "<tr><th>Data</th><th>Tipo</th><th>Origem</th><th>Descrição</th><th>Entidade</th><th>Forma Pagamento</th><th>Valor</th></tr>";
    
    $transacoes = $conexao->query("SELECT * FROM transacoes $filtro_sql ORDER BY data_transacao DESC");
    $total_receitas = 0;
    $total_despesas = 0;
    
    while ($t = $transacoes->fetch_assoc()) {
        $valor_formatado = number_format($t['valor'], 2, ',', '.');
        if ($t['tipo'] == 'Receita') {
            $total_receitas += $t['valor'];
            $valor_display = "+ R$ $valor_formatado";
        } else {
            $total_despesas += $t['valor'];
            $valor_display = "- R$ $valor_formatado";
        }
        
        echo "<tr>";
        echo "<td>" . date("d/m/Y", strtotime($t['data_transacao'])) . "</td>";
        echo "<td>" . $t['tipo'] . "</td>";
        echo "<td>" . htmlspecialchars($t['origem']) . "</td>";
        echo "<td>" . htmlspecialchars($t['descricao']) . "</td>";
        echo "<td>" . htmlspecialchars($t['entidade'] ?? '-') . "</td>";
        echo "<td>" . htmlspecialchars($t['forma_pagamento'] ?? '-') . "</td>";
        echo "<td>$valor_display</td>";
        echo "</tr>";
    }
    
    $saldo = $total_receitas - $total_despesas;
    echo "<tr><td colspan='6' style='font-weight:bold; text-align:right;'>Total Receitas:</td><td style='font-weight:bold; color:green;'>R$ " . number_format($total_receitas, 2, ',', '.') . "</td></tr>";
    echo "<tr><td colspan='6' style='font-weight:bold; text-align:right;'>Total Despesas:</td><td style='font-weight:bold; color:red;'>R$ " . number_format($total_despesas, 2, ',', '.') . "</td></tr>";
    echo "<tr><td colspan='6' style='font-weight:bold; text-align:right;'>Saldo Final:</td><td style='font-weight:bold; color:blue;'>R$ " . number_format($saldo, 2, ',', '.') . "</td></tr>";
    echo "</table>";
    exit();
}

function gerarPDF($conexao, $filtro_sql, $ano, $mes) {
    // Implementação básica de PDF sem biblioteca externa
    $nomes_meses = [1=>'Janeiro', 2=>'Fevereiro', 3=>'Março', 4=>'Abril', 5=>'Maio', 6=>'Junho', 7=>'Julho', 8=>'Agosto', 9=>'Setembro', 10=>'Outubro', 11=>'Novembro', 12=>'Dezembro'];
    $periodo = $mes == 0 ? "Relatório Anual de $ano" : "Relatório de " . $nomes_meses[$mes] . " de $ano";
    
    header('Content-Type: text/html; charset=utf-8');
    header('Content-Disposition: attachment; filename="Relatorio_' . ($mes == 0 ? "Anual_$ano" : $nomes_meses[$mes] . "_$ano") . '.html"');
    
    echo "<!DOCTYPE html><html><head><meta charset='utf-8'><title>$periodo</title>";
    echo "<style>body{font-family:Arial,sans-serif;margin:20px;}table{width:100%;border-collapse:collapse;}th,td{border:1px solid #ddd;padding:8px;text-align:left;}th{background-color:#f2f2f2;}</style>";
    echo "</head><body>";
    echo "<h1>Financeiro Imobiliária e Aury</h1>";
    echo "<h2>$periodo</h2>";
    
    // Buscar dados
    $receitas = $conexao->query("SELECT SUM(valor) as total FROM transacoes $filtro_sql AND tipo = 'Receita'")->fetch_assoc()['total'] ?? 0;
    $despesas = $conexao->query("SELECT SUM(valor) as total FROM transacoes $filtro_sql AND tipo = 'Despesa'")->fetch_assoc()['total'] ?? 0;
    $saldo = $receitas - $despesas;
    
    echo "<table><tr><th>Resumo Financeiro</th><th>Valor</th></tr>";
    echo "<tr><td>Total de Receitas</td><td style='color:green;'>R$ " . number_format($receitas, 2, ',', '.') . "</td></tr>";
    echo "<tr><td>Total de Despesas</td><td style='color:red;'>R$ " . number_format($despesas, 2, ',', '.') . "</td></tr>";
    echo "<tr><td><strong>Saldo Final</strong></td><td style='color:blue;'><strong>R$ " . number_format($saldo, 2, ',', '.') . "</strong></td></tr>";
    echo "</table><br>";
    
    echo "<h3>Detalhamento das Transações</h3>";
    echo "<table><tr><th>Data</th><th>Tipo</th><th>Descrição</th><th>Entidade</th><th>Valor</th></tr>";
    
    $transacoes = $conexao->query("SELECT * FROM transacoes $filtro_sql ORDER BY data_transacao DESC");
    while ($t = $transacoes->fetch_assoc()) {
        $cor = $t['tipo'] == 'Receita' ? 'green' : 'red';
        $sinal = $t['tipo'] == 'Receita' ? '+' : '-';
        echo "<tr>";
        echo "<td>" . date("d/m/Y", strtotime($t['data_transacao'])) . "</td>";
        echo "<td>" . $t['tipo'] . "</td>";
        echo "<td>" . htmlspecialchars($t['descricao']) . "</td>";
        echo "<td>" . htmlspecialchars($t['entidade'] ?? '-') . "</td>";
        echo "<td style='color:$cor;'>$sinal R$ " . number_format($t['valor'], 2, ',', '.') . "</td>";
        echo "</tr>";
    }
    echo "</table></body></html>";
    exit();
}

// Buscar dados para os gráficos
$ano_atual = date('Y');
$dados_mensais = [];
for ($i = 1; $i <= 12; $i++) {
    $receitas = $conexao->query("SELECT SUM(valor) as total FROM transacoes WHERE YEAR(data_transacao) = $ano_atual AND MONTH(data_transacao) = $i AND tipo = 'Receita'")->fetch_assoc()['total'] ?? 0;
    $despesas = $conexao->query("SELECT SUM(valor) as total FROM transacoes WHERE YEAR(data_transacao) = $ano_atual AND MONTH(data_transacao) = $i AND tipo = 'Despesa'")->fetch_assoc()['total'] ?? 0;
    $dados_mensais[] = ['mes' => $i, 'receitas' => (float)$receitas, 'despesas' => (float)$despesas];
}

// Dados por origem
$dados_origem = $conexao->query("
    SELECT origem, SUM(valor) as total, tipo 
    FROM transacoes 
    WHERE YEAR(data_transacao) = $ano_atual 
    GROUP BY origem, tipo 
    ORDER BY total DESC
")->fetch_all(MYSQLI_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Relatórios - Financeiro Imobiliária e Aury</title>
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels@2.0.0"></script>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: #333; min-height: 100vh; }
        
        .header { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); box-shadow: 0 4px 20px rgba(0,0,0,0.1); padding: 20px 0; margin-bottom: 30px; }
        .header-content { max-width: 1200px; margin: 0 auto; display: flex; align-items: center; justify-content: space-between; padding: 0 25px; }
        .logo-section { display: flex; align-items: center; gap: 20px; }
        .logo-section img { height: 60px; width: auto; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .title-section h1 { font-size: 28px; font-weight: 700; color: #2c3e50; margin-bottom: 5px; }
        .title-section p { font-size: 14px; color: #7f8c8d; font-weight: 500; }
        
        .container { max-width: 1200px; margin: auto; background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); padding: 30px; border-radius: 16px; box-shadow: 0 8px 32px rgba(0,0,0,0.1); }
        
        .navigation { display: flex; justify-content: center; gap: 15px; margin-bottom: 30px; padding: 15px; background: rgba(52, 73, 94, 0.05); border-radius: 12px; }
        .nav-link { padding: 12px 24px; background: linear-gradient(135deg, #3498db, #2980b9); color: white; text-decoration: none; border-radius: 8px; transition: all 0.3s ease; font-weight: 500; box-shadow: 0 2px 8px rgba(52, 152, 219, 0.3); }
        .nav-link:hover { transform: translateY(-2px); box-shadow: 0 4px 16px rgba(52, 152, 219, 0.4); }
        .nav-link.active { background: linear-gradient(135deg, #2c3e50, #34495e); box-shadow: 0 4px 16px rgba(44, 62, 80, 0.4); }
        
        .form-container { background: linear-gradient(135deg, #f8f9fa, #e9ecef); padding: 25px; border-radius: 12px; margin-bottom: 25px; box-shadow: 0 4px 16px rgba(0,0,0,0.05); }
        .form-container h2 { color: #2c3e50; margin-bottom: 20px; font-weight: 600; }
        
        .form-row { display: grid; grid-template-columns: repeat(auto-fit, minmax(150px, 1fr)); gap: 20px; align-items: end; }
        .form-group { display: flex; flex-direction: column; }
        .form-group label { margin-bottom: 8px; font-weight: 600; color: #2c3e50; font-size: 14px; }
        .form-group select { padding: 12px; border: 2px solid #e9ecef; border-radius: 8px; font-size: 14px; transition: all 0.3s ease; background: white; }
        .form-group select:focus { outline: none; border-color: #3498db; box-shadow: 0 0 0 3px rgba(52, 152, 219, 0.1); }
        
        .btn { padding: 12px 24px; border: none; border-radius: 8px; font-size: 14px; font-weight: 600; cursor: pointer; text-decoration: none; display: inline-block; text-align: center; transition: all 0.3s ease; }
        .btn-primary { background: linear-gradient(135deg, #3498db, #2980b9); color: white; box-shadow: 0 4px 16px rgba(52, 152, 219, 0.3); }
        .btn-success { background: linear-gradient(135deg, #27ae60, #2ecc71); color: white; box-shadow: 0 4px 16px rgba(39, 174, 96, 0.3); }
        .btn:hover { transform: translateY(-2px); }
        
        .charts-container { display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 30px; margin: 30px 0; }
        .chart-box { background: linear-gradient(135deg, #f8f9fa, #e9ecef); padding: 25px; border-radius: 12px; box-shadow: 0 4px 16px rgba(0,0,0,0.05); }
        .chart-box h3 { margin-top: 0; text-align: center; color: #2c3e50; font-weight: 600; margin-bottom: 20px; }
        
        @media (max-width: 768px) {
            .header-content { flex-direction: column; gap: 15px; text-align: center; }
            .navigation { flex-direction: column; align-items: center; }
            .form-row { grid-template-columns: 1fr; }
            .charts-container { grid-template-columns: 1fr; }
            .container { margin: 20px; padding: 20px; }
        }
    </style>
</head>
<body>

<div class="header">
    <div class="header-content">
        <div class="logo-section">
            <img src="/publico_html/assets/img/logo.png" alt="Logo Imobiliária">
            <div class="title-section">
                <h1>Financeiro Imobiliária e Aury</h1>
                <p>Relatórios e Análises Financeiras</p>
            </div>
        </div>
    </div>
</div>

<div class="container">
    
    <div class="navigation">
        <a href="index.php" class="nav-link">Dashboard</a>
        <a href="contas.php" class="nav-link">Controle de Contas</a>
        <a href="relatorios.php" class="nav-link active">Relatórios</a>
    </div>

    <div class="form-container">
        <h2>Gerar Relatórios</h2>
        <form action="relatorios.php" method="GET">
            <div class="form-row">
                <div class="form-group">
                    <label for="ano">Ano</label>
                    <select name="ano" id="ano">
                        <?php for ($ano = date('Y'); $ano >= date('Y') - 5; $ano--): ?>
                            <option value="<?= $ano ?>"><?= $ano ?></option>
                        <?php endfor; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="mes">Mês</label>
                    <select name="mes" id="mes">
                        <option value="0">Todos os Meses (Anual)</option>
                        <option value="1">Janeiro</option>
                        <option value="2">Fevereiro</option>
                        <option value="3">Março</option>
                        <option value="4">Abril</option>
                        <option value="5">Maio</option>
                        <option value="6">Junho</option>
                        <option value="7">Julho</option>
                        <option value="8">Agosto</option>
                        <option value="9">Setembro</option>
                        <option value="10">Outubro</option>
                        <option value="11">Novembro</option>
                        <option value="12">Dezembro</option>
                    </select>
                </div>
                <div class="form-group">
                    <button type="submit" name="gerar" value="pdf" class="btn btn-primary">Gerar PDF</button>
                </div>
                <div class="form-group">
                    <button type="submit" name="gerar" value="excel" class="btn btn-success">Gerar Excel</button>
                </div>
            </div>
        </form>
    </div>

    <div class="charts-container">
        <div class="chart-box">
            <h3>Evolução Mensal <?= $ano_atual ?></h3>
            <canvas id="chartMensal" width="400" height="200"></canvas>
        </div>
        
        <div class="chart-box">
            <h3>Distribuição por Origem</h3>
            <canvas id="chartOrigem" width="400" height="200"></canvas>
        </div>
    </div>

    <div class="chart-box" style="margin-top: 30px;">
        <h3>Comparativo Receitas vs Despesas</h3>
        <canvas id="chartComparativo" width="800" height="300"></canvas>
    </div>

</div>

<script>
// REGISTRAR O PLUGIN GLOBALMENTE
Chart.register(ChartDataLabels);

// Dados para os gráficos
const dadosMensais = <?= json_encode($dados_mensais) ?>;
const dadosOrigem = <?= json_encode($dados_origem) ?>;

// --- FUNÇÃO AUXILIAR PARA FORMATAR VALORES COMO MOEDA BRASILEIRA ---
function formatarMoeda(valor) {
    if (valor === 0) return null; // Não mostra o rótulo se o valor for zero
    return valor.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
}

// Gráfico Mensal com VALORES
const ctxMensal = document.getElementById('chartMensal').getContext('2d');
new Chart(ctxMensal, {
    type: 'line',
    data: {
        labels: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
        datasets: [{
            label: 'Receitas',
            data: dadosMensais.map(d => d.receitas),
            borderColor: '#27ae60',
            backgroundColor: 'rgba(39, 174, 96, 0.1)',
            tension: 0.4,
            borderWidth: 3
        }, {
            label: 'Despesas',
            data: dadosMensais.map(d => d.despesas),
            borderColor: '#e74c3c',
            backgroundColor: 'rgba(231, 76, 60, 0.1)',
            tension: 0.4,
            borderWidth: 3
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { position: 'top' },
            // Configuração para exibir os valores no gráfico de linha
            datalabels: {
                align: 'end',
                anchor: 'end',
                backgroundColor: 'rgba(255, 255, 255, 0.7)',
                borderRadius: 4,
                padding: 4,
                font: {
                    weight: 'bold',
                    size: 10
                },
                formatter: formatarMoeda // Usa a função auxiliar
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: value => value.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' })
                }
            }
        }
    }
});

// Gráfico por Origem com VALORES
const ctxOrigem = document.getElementById('chartOrigem').getContext('2d');
const cores = ['#3498db', '#e74c3c', '#f39c12', '#9b59b6', '#1abc9c', '#34495e'];
new Chart(ctxOrigem, {
    type: 'doughnut',
    data: {
        labels: dadosOrigem.map(d => d.origem.replace(/_/g, ' ')),
        datasets: [{
            data: dadosOrigem.map(d => d.total),
            backgroundColor: cores,
            borderWidth: 3,
            borderColor: '#fff'
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'bottom',
                labels: { padding: 20, font: { weight: 'bold' } }
            },
            // Configuração para exibir os valores no gráfico de pizza
            datalabels: {
                color: '#fff',
                font: {
                    weight: 'bold',
                    size: 12
                },
                formatter: (value) => value.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL', minimumFractionDigits: 0 })
            }
        }
    }
});

// Gráfico Comparativo com VALORES
const ctxComparativo = document.getElementById('chartComparativo').getContext('2d');
new Chart(ctxComparativo, {
    type: 'bar',
    data: {
        labels: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez'],
        datasets: [{
            label: 'Receitas',
            data: dadosMensais.map(d => d.receitas),
            backgroundColor: 'rgba(39, 174, 96, 0.8)',
            borderColor: '#27ae60',
            borderWidth: 2
        }, {
            label: 'Despesas',
            data: dadosMensais.map(d => d.despesas),
            backgroundColor: 'rgba(231, 76, 60, 0.8)',
            borderColor: '#e74c3c',
            borderWidth: 2
        }, {
            label: 'Saldo',
            data: dadosMensais.map(d => d.receitas - d.despesas),
            backgroundColor: 'rgba(52, 152, 219, 0.8)',
            borderColor: '#3498db',
            borderWidth: 3,
            type: 'line',
            fill: false,
            datalabels: { display: false } // Desabilitar rótulos para a linha de saldo
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { position: 'top' },
            // Configuração para exibir os valores no gráfico de barras
            datalabels: {
                align: 'end',
                anchor: 'end',
                color: '#555',
                font: {
                    weight: 'bold',
                    size: 10,
                },
                formatter: formatarMoeda // Usa a função auxiliar
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: {
                    callback: value => value.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' })
                }
            }
        }
    }
});
</script>

</body>
</html>
<?php $conexao->close(); ?>