<?php
echo "<h1>Verificação do arquivo db.php</h1>";

if (file_exists('db.php')) {
    $conteudo = file_get_contents('db.php');
    
    if (strpos($conteudo, 'fazer_upload_arquivo') !== false) {
        echo "<p style='color:green;'>✅ Função fazer_upload_arquivo encontrada no db.php</p>";
    } else {
        echo "<p style='color:red;'>❌ Função fazer_upload_arquivo NÃO encontrada no db.php</p>";
        echo "<h2>Adicione esta função ao final do seu db.php:</h2>";
        echo "<pre style='background:#f4f4f4; padding:15px; border-radius:5px;'>";
        echo htmlspecialchars('
// Função para upload de arquivos
function fazer_upload_arquivo($arquivo, $pasta_destino = \'uploads/comprovantes/\') {
    if (!file_exists($pasta_destino)) {
        mkdir($pasta_destino, 0777, true);
    }
    
    $extensoes_permitidas = [\'jpg\', \'jpeg\', \'png\', \'pdf\', \'doc\', \'docx\'];
    $extensao = strtolower(pathinfo($arquivo[\'name\'], PATHINFO_EXTENSION));
    
    if (!in_array($extensao, $extensoes_permitidas)) {
        return false;
    }
    
    $nome_arquivo = uniqid() . \'_\' . time() . \'.\' . $extensao;
    $caminho_completo = $pasta_destino . $nome_arquivo;
    
    if (move_uploaded_file($arquivo[\'tmp_name\'], $caminho_completo)) {
        return $nome_arquivo;
    }
    
    return false;
}
');
        echo "</pre>";
    }
} else {
    echo "<p style='color:red;'>❌ Arquivo db.php não encontrado</p>";
}

echo "<hr>";
echo "<p><a href='index.php' style='background:#27ae60; color:white; padding:10px 20px; text-decoration:none; border-radius:5px;'>🚀 Testar Dashboard</a></p>";
echo "<p><strong>Delete este arquivo após verificar!</strong></p>";
?>
